/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.view;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.flexdock.plaf.PlafManager;
import org.flexdock.plaf.theme.TitlebarUI;
import org.flexdock.view.Button;
import org.flexdock.view.View;
import org.flexdock.view.actions.ViewAction;
import org.flexdock.view.model.ViewButtonModel;

public class Titlebar
extends JComponent {
    public static final String uiClassID = "Flexdock.titlebar";
    private Icon titleIcon;
    private String titleText;
    private List actionList;
    private HashMap actionButtons;
    private Button[] buttonList;
    private View parentView;

    public Titlebar() {
        this(null, null);
    }

    public Titlebar(String title) {
        this(title, null);
    }

    public Titlebar(Action[] actions) {
        this(null, actions);
    }

    public Titlebar(String title, Action[] actions) {
        this.setText(title);
        this.setActions(actions);
        this.updateUI();
    }

    public void setText(String text) {
        this.titleText = text == null ? "" : text;
        this.repaint();
    }

    protected void setActions(Action[] actions) {
        if (actions == null) {
            actions = new Action[]{};
            this.actionList = new ArrayList(3);
            this.actionButtons = new HashMap(3);
        }
        this.removeAllActions();
        for (int i = 0; i < actions.length; ++i) {
            this.addAction(actions[i]);
        }
    }

    public synchronized void addAction(String actionName) {
        if (actionName == null || !(this.ui instanceof TitlebarUI)) {
            return;
        }
        TitlebarUI tbarUI = (TitlebarUI)this.ui;
        Action action = tbarUI.getAction(actionName);
        this.addAction(action);
    }

    public synchronized void addAction(Action action) {
        if (action == null) {
            return;
        }
        String key = this.getKey(action);
        if (key == null) {
            throw new IllegalArgumentException("Cannot add an Action that has no Name associated with it.");
        }
        if (this.hasAction(key)) {
            return;
        }
        Button button = this.createActionButton(action);
        this.actionButtons.put(key, button);
        this.add(button);
        this.actionList.add(action);
        this.regenerateButtonList();
        this.updateButtonModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateButtonList() {
        Button[] list = new Button[this.actionList.size()];
        for (int i = 0; i < list.length; ++i) {
            Action action = (Action)this.actionList.get(i);
            String key = this.getKey(action);
            list[i] = this.getButton(key);
        }
        Titlebar titlebar = this;
        synchronized (titlebar) {
            this.buttonList = list;
        }
    }

    public Action getAction(String key) {
        if (key == null) {
            return null;
        }
        for (Action action : this.actionList) {
            String actionName = (String)action.getValue("Name");
            if (!key.equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public Action[] getActions() {
        return this.actionList.toArray(new Action[0]);
    }

    protected Button getButton(String key) {
        return (Button)this.actionButtons.get(key);
    }

    public AbstractButton getActionButton(String actionName) {
        return this.getButton(actionName);
    }

    protected boolean hasAction(String key) {
        return this.actionButtons.containsKey(key);
    }

    public Icon getIcon() {
        return this.titleIcon;
    }

    public String getText() {
        return this.titleText;
    }

    public void removeAction(Action action) {
        if (action == null) {
            return;
        }
        String key = this.getKey(action);
        this.removeAction(key);
    }

    public synchronized void removeAction(String key) {
        if (!this.hasAction(key)) {
            return;
        }
        Button button = this.getButton(key);
        this.remove(button);
        this.actionButtons.remove(key);
        Action action = this.getAction(key);
        this.actionList.remove(action);
        this.regenerateButtonList();
        this.updateButtonModels();
    }

    protected synchronized void removeAllActions() {
        if (this.actionList == null) {
            return;
        }
        while (this.actionList.size() > 0) {
            Action action = (Action)this.actionList.get(0);
            String key = this.getKey(action);
            Button button = this.getButton(key);
            this.remove(button);
            this.actionButtons.remove(key);
            this.actionList.remove(0);
        }
        this.regenerateButtonList();
    }

    protected String getKey(Action action) {
        Object obj = action == null ? null : action.getValue("Name");
        return obj instanceof String ? (String)obj : null;
    }

    protected Icon getIcon(Action action) {
        Object obj = action == null ? null : action.getValue("SmallIcon");
        return obj instanceof Icon ? (Icon)obj : null;
    }

    public void setIcon(Icon icon) {
        this.titleIcon = icon;
    }

    public boolean isActive() {
        return this.parentView == null ? false : this.parentView.isActive();
    }

    void setView(View view) {
        this.setParentView(view);
    }

    protected void setParentView(View view) {
        this.parentView = view;
        this.updateButtonModels();
    }

    public Button createActionButton(Action action) {
        ButtonModel model;
        Button button = new Button(action);
        if (this.ui instanceof TitlebarUI) {
            ((TitlebarUI)this.ui).configureAction(action);
        }
        if (action instanceof ViewAction && (model = ((ViewAction)action).createButtonModel()) != null) {
            button.setModel(model);
        }
        return button;
    }

    private void updateButtonModels() {
        String viewId = this.parentView == null ? null : this.parentView.getPersistentId();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ButtonModel bm;
            Button button;
            Button button2 = button = comps[i] instanceof Button ? (Button)comps[i] : null;
            if (button == null || !((bm = button.getModel()) instanceof ViewButtonModel)) continue;
            ((ViewButtonModel)bm).setViewId(viewId);
        }
    }

    public void doLayout() {
        if (this.ui instanceof TitlebarUI) {
            ((TitlebarUI)this.ui).layoutComponents(this);
        }
    }

    public void updateUI() {
        this.setUI(PlafManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public View getView() {
        return (View)SwingUtilities.getAncestorOfClass(View.class, this);
    }
}

