/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.flexdock.plaf.FlexViewComponentUI;
import org.flexdock.plaf.icons.IconMap;
import org.flexdock.plaf.icons.IconResource;
import org.flexdock.plaf.icons.IconResourceFactory;
import org.flexdock.plaf.resources.paint.Painter;
import org.flexdock.view.Button;
import org.flexdock.view.Titlebar;
import org.flexdock.view.View;

public class TitlebarUI
extends FlexViewComponentUI {
    public static final String DEFAULT_HEIGHT = "default.height";
    public static final String FONT = "font";
    public static final String FONT_COLOR = "font.color";
    public static final String FONT_COLOR_ACTIVE = "font.color.active";
    public static final String BACKGROUND_COLOR = "bgcolor";
    public static final String BACKGROUND_COLOR_ACTIVE = "bgcolor.active";
    public static final String BORDER = "border";
    public static final String BORDER_ACTIVE = "border.active";
    public static final String PAINTER = "painter";
    public static final String INSETS = "insets";
    private static final String BUTTON_MARGIN = "button.margin";
    public static final String ICON_INSETS = "icon.insets";
    public static final String ANTIALIASING = "antialiasing";
    public static final int MINIMUM_HEIGHT = 12;
    protected Font font;
    protected Color activeFont;
    protected Color inactiveFont;
    protected Color activeBackground;
    protected Color inactiveBackground;
    protected Border activeBorder;
    protected Border inactiveBorder;
    protected IconMap defaultIcons;
    protected Painter painter;
    protected Insets insets;
    protected int buttonMargin;
    protected Insets iconInsets;
    protected Object antialiasing;
    protected int defaultHeight = 12;

    public void installUI(JComponent c) {
        Font current;
        super.installUI(c);
        Dimension d = c.getPreferredSize();
        d.height = this.getDefaultHeight();
        c.setPreferredSize(d);
        this.reconfigureActions(c);
        if (this.font != null && ((current = c.getFont()) == null || current instanceof UIResource)) {
            c.setFont(new FontUIResource(this.font));
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent jc) {
        Titlebar titlebar = (Titlebar)jc;
        this.paintBackground(g, titlebar);
        this.paintIcon(g, titlebar);
        this.paintTitle(g, titlebar);
        this.paintBorder(g, titlebar);
    }

    protected void paintBackground(Graphics g, Titlebar titlebar) {
        Rectangle paintArea = this.getPaintRect(titlebar);
        g.translate(paintArea.x, paintArea.y);
        this.painter.paint(g, paintArea.width, paintArea.height, titlebar.isActive(), titlebar);
        g.translate(-paintArea.x, -paintArea.y);
    }

    protected Rectangle getPaintRect(Titlebar titlebar) {
        if (this.getInsets() == null) {
            return new Rectangle(0, 0, titlebar.getWidth(), titlebar.getHeight());
        }
        Insets paintInsets = this.getInsets();
        return new Rectangle(paintInsets.left, paintInsets.top, titlebar.getWidth() - paintInsets.right - paintInsets.left, titlebar.getHeight() - paintInsets.bottom - paintInsets.top);
    }

    protected void paintTitle(Graphics g, Titlebar titlebar) {
        Object textAntialiasing;
        if (titlebar.getText() == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing);
        Map desktopHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (desktopHints != null && (textAntialiasing = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) != null) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntialiasing);
        }
        g2.setFont(titlebar.getFont());
        Rectangle iconRect = this.getIconRect(titlebar);
        Rectangle paintRect = this.getPaintRect(titlebar);
        int x = this.getTextLocation(iconRect);
        FontMetrics fm = g.getFontMetrics();
        int y = (paintRect.height + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
        Color c = this.getFontColor(titlebar.isActive());
        g2.setColor(c);
        g.translate(paintRect.x, paintRect.y);
        g2.drawString(titlebar.getText(), x, y);
        g.translate(-paintRect.x, -paintRect.y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAValue);
    }

    protected int getTextLocation(Rectangle iconRect) {
        if (iconRect.width > 0) {
            return iconRect.x + iconRect.width + this.getRightIconMargin();
        }
        return 5;
    }

    protected void paintIcon(Graphics g, Titlebar titlebar) {
        if (titlebar.getIcon() == null) {
            return;
        }
        Icon icon = titlebar.getIcon();
        Rectangle r = this.getIconRect(titlebar);
        Rectangle paintRect = this.getPaintRect(titlebar);
        g.translate(paintRect.x, paintRect.y);
        icon.paintIcon(titlebar, g, r.x, r.y);
        g.translate(-paintRect.x, -paintRect.y);
    }

    protected Rectangle getIconRect(Titlebar titlebar) {
        Icon icon = titlebar.getIcon();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (icon == null) {
            return r;
        }
        Rectangle paintRect = this.getPaintRect(titlebar);
        r.x = this.getLeftIconMargin();
        r.width = icon.getIconWidth();
        r.height = icon.getIconHeight();
        r.y = (paintRect.height - r.height) / 2;
        return r;
    }

    protected int getLeftIconMargin() {
        return this.getIconInsets() == null ? 2 : this.getIconInsets().right;
    }

    protected int getRightIconMargin() {
        return this.getIconInsets() == null ? 2 : this.getIconInsets().right;
    }

    protected void paintBorder(Graphics g, Titlebar titlebar) {
        Border border = this.getBorder(titlebar);
        if (border != null) {
            Rectangle rectangle = this.getPaintRect(titlebar);
            g.translate(rectangle.x, rectangle.y);
            border.paintBorder(titlebar, g, 0, 0, rectangle.width, rectangle.height);
            g.translate(-rectangle.x, -rectangle.y);
        }
    }

    public void layoutComponents(Titlebar titlebar) {
        Rectangle rectangle = this.getPaintRect(titlebar);
        int margin = this.getButtonMargin();
        int h = rectangle.height - 2 * margin;
        int x = rectangle.width - margin - h;
        View view = titlebar.getView();
        Component[] c = titlebar.getComponents();
        for (int i = 0; i < c.length; ++i) {
            int width = c[i].getPreferredSize().width;
            if (c[i] instanceof Button) {
                width = h;
                if (view != null && view.isActionBlocked(((Button)c[i]).getActionName())) {
                    c[i].setBounds(0, 0, 0, 0);
                    continue;
                }
            }
            c[i].setBounds(x, margin + rectangle.y, width, h);
            x -= width;
        }
    }

    public void configureAction(Action action) {
        if (action == null) {
            return;
        }
        IconResource icons = this.getIcons(action);
        if (icons != null) {
            action.putValue("flexdock.button.icon.resource", icons);
        }
    }

    private void reconfigureActions(JComponent c) {
        Component[] c1 = c.getComponents();
        for (int i = 0; i < c1.length; ++i) {
            if (!(c1[i] instanceof Button)) continue;
            Button b = (Button)c1[i];
            this.configureAction(b.getAction());
        }
    }

    protected Color getFontColor(boolean active) {
        Color c = active ? this.activeFont : this.inactiveFont;
        return c == null ? this.inactiveFont : c;
    }

    protected Color getBackgroundColor(boolean active) {
        Color color = active ? this.activeBackground : this.inactiveBackground;
        return color == null ? this.inactiveBackground : color;
    }

    protected Border getBorder(Titlebar titlebar) {
        boolean active = titlebar.isActive();
        return active ? this.activeBorder : this.inactiveBorder;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight = Math.max(defaultHeight, 12);
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, this.getDefaultHeight());
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public void setActiveBackground(Color activeBackground) {
        this.activeBackground = activeBackground;
    }

    public Color getActiveFont() {
        return this.activeFont;
    }

    public void setActiveFont(Color activeFont) {
        this.activeFont = activeFont;
    }

    public Color getInactiveBackground() {
        return this.inactiveBackground;
    }

    public void setInactiveBackground(Color inactiveBackground) {
        this.inactiveBackground = inactiveBackground;
    }

    public Color getInactiveFont() {
        return this.inactiveFont;
    }

    public void setInactiveFont(Color inactiveFont) {
        this.inactiveFont = inactiveFont;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public IconMap getDefaultIcons() {
        return this.defaultIcons;
    }

    public void setDefaultIcons(IconMap defaultIcons) {
        this.defaultIcons = defaultIcons;
    }

    public void setDefaultIcons(String iconMapName) {
        IconMap map = IconResourceFactory.getIconMap(iconMapName);
        this.setDefaultIcons(map);
    }

    public IconResource getIcons(Action action) {
        String key = action == null ? null : (String)action.getValue("Name");
        return this.getIcons(key);
    }

    public IconResource getIcons(String key) {
        return this.defaultIcons == null ? null : this.defaultIcons.getIcons(key);
    }

    public Action getAction(String actionKey) {
        Action action;
        IconResource resource = this.getIcons(actionKey);
        Action action2 = action = resource == null ? null : resource.getAction();
        if (action != null) {
            action.putValue("Name", actionKey);
        }
        return action;
    }

    public Border getInactiveBorder() {
        return this.inactiveBorder;
    }

    public void setInactiveBorder(Border inactiveBorder) {
        this.inactiveBorder = inactiveBorder;
    }

    public Border getActiveBorder() {
        return this.activeBorder;
    }

    public void setActiveBorder(Border activeBorder) {
        this.activeBorder = activeBorder;
    }

    public Insets getIconInsets() {
        return this.iconInsets;
    }

    public void setIconInsets(Insets iconInsets) {
        this.iconInsets = iconInsets;
    }

    public int getButtonMargin() {
        return this.buttonMargin;
    }

    public void setButtonMargin(int buttonMargin) {
        this.buttonMargin = buttonMargin;
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public boolean isAntialiasing() {
        return this.antialiasing == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public void setAntialiasing(boolean antialias) {
        this.antialiasing = antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
    }

    public void initializeCreationParameters() {
        this.setActiveBackground(this.creationParameters.getColor(BACKGROUND_COLOR_ACTIVE));
        this.setActiveFont(this.creationParameters.getColor(FONT_COLOR_ACTIVE));
        this.setInactiveBackground(this.creationParameters.getColor(BACKGROUND_COLOR));
        this.setInactiveFont(this.creationParameters.getColor(FONT_COLOR));
        this.setDefaultHeight(this.creationParameters.getInt(DEFAULT_HEIGHT));
        this.setFont(this.creationParameters.getFont(FONT));
        this.setInactiveBorder(this.creationParameters.getBorder(BORDER));
        this.setActiveBorder(this.creationParameters.getBorder(BORDER_ACTIVE));
        this.setDefaultIcons(this.creationParameters.getString("icon-map"));
        this.setPainter((Painter)this.creationParameters.getProperty(PAINTER));
        this.setIconInsets((Insets)this.creationParameters.getProperty(ICON_INSETS));
        this.setButtonMargin(this.creationParameters.getInt(BUTTON_MARGIN));
        this.setPainter((Painter)this.creationParameters.getProperty(PAINTER));
        this.setInsets((Insets)this.creationParameters.getProperty(INSETS));
        this.setAntialiasing(this.creationParameters.getBoolean(ANTIALIASING));
    }

    public String getPreferredButtonUI() {
        return this.creationParameters.getString("button-ui");
    }
}

