/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import java.util.List;
import org.flexdock.docking.state.DockingPath;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.flexdock.perspective.persist.xml.SerializerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DockingPathSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        DockingPath dockingPath = (DockingPath)object;
        Element dockingPathElement = document.createElement("DockingPath");
        dockingPathElement.setAttribute("rootPortId", dockingPath.getRootPortId());
        if (dockingPath.getSiblingId() != null && !dockingPath.getSiblingId().equals("")) {
            dockingPathElement.setAttribute("siblingId", dockingPath.getSiblingId());
        }
        if (dockingPath.isTabbed()) {
            dockingPathElement.setAttribute("isTabbed", String.valueOf(dockingPath.isTabbed()));
        }
        List splitNodes = dockingPath.getNodes();
        ISerializer splitNodeSerializer = SerializerRegistry.getSerializer(SplitNode.class);
        for (SplitNode splitNode : splitNodes) {
            Element splitNodeElement = splitNodeSerializer.serialize(document, splitNode);
            dockingPathElement.appendChild(splitNodeElement);
        }
        return dockingPathElement;
    }

    public Object deserialize(Element element) {
        DockingPath dockingPath = new DockingPath();
        String dockingPathRootPortId = element.getAttribute("rootPortId");
        String siblingId = element.getAttribute("siblingId");
        String isTabbed = element.getAttribute("isTabbed");
        dockingPath.setRootPortId(dockingPathRootPortId);
        if (siblingId != null && !"".equals(siblingId)) {
            dockingPath.setSiblingId(siblingId);
        }
        if (isTabbed != null && !"".equals(isTabbed)) {
            dockingPath.setTabbed(Boolean.valueOf(isTabbed));
        } else {
            dockingPath.setTabbed(false);
        }
        ISerializer layoutNodeSerializer = SerializerRegistry.getSerializer(LayoutNode.class);
        NodeList splitNodeList = element.getElementsByTagName("SplitNode");
        if (splitNodeList.getLength() > 0 && splitNodeList.item(0) instanceof Element) {
            Element splitNodeElement = (Element)splitNodeList.item(0);
            SplitNode splitNode = (SplitNode)layoutNodeSerializer.deserialize(splitNodeElement);
            dockingPath.getNodes().add(splitNode);
        }
        return dockingPath;
    }
}

