/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.state;

import java.awt.Point;
import java.io.Serializable;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.state.DockingPath;

public class DockingState
implements Cloneable,
Serializable,
DockingConstants {
    private String m_dockableId;
    private String m_relativeParentId;
    private String m_region = "UNKNOWN";
    private float m_splitRatio = -1.0f;
    private String m_floatingGroup;
    private int m_minimizedConstraint = -1;
    private DockingPath m_dockingPath;
    private int centerX = -1;
    private int centerY = -1;

    public DockingState(String dockableId) {
        this.m_dockableId = dockableId;
    }

    public Dockable getDockable() {
        return DockingManager.getDockable(this.m_dockableId);
    }

    public String getDockableId() {
        return this.m_dockableId;
    }

    public float getSplitRatio() {
        return this.m_splitRatio;
    }

    public void setSplitRatio(float ratio) {
        this.m_splitRatio = ratio;
    }

    public String getRegion() {
        return this.m_region;
    }

    public void setRegion(String region) {
        this.m_region = region;
    }

    public int getMinimizedConstraint() {
        return this.m_minimizedConstraint;
    }

    public String getFloatingGroup() {
        return this.m_floatingGroup;
    }

    public boolean isFloating() {
        return this.m_floatingGroup != null;
    }

    public boolean isMinimized() {
        return this.m_minimizedConstraint != -1;
    }

    public boolean hasDockingPath() {
        return this.m_dockingPath != null;
    }

    public DockingPath getPath() {
        return this.m_dockingPath;
    }

    public void setPath(DockingPath path) {
        this.m_dockingPath = path;
    }

    public void setMinimizedConstraint(int constraint) {
        this.m_minimizedConstraint = constraint;
        if (constraint != -1) {
            this.m_floatingGroup = null;
        }
    }

    public void setFloatingGroup(String group) {
        this.m_floatingGroup = group;
        if (group != null) {
            this.m_minimizedConstraint = -1;
        }
    }

    public Dockable getRelativeParent() {
        return DockingManager.getDockable(this.m_relativeParentId);
    }

    public String getRelativeParentId() {
        return this.m_relativeParentId;
    }

    public void setRelativeParent(Dockable parent) {
        String parentId = parent == null ? null : parent.getPersistentId();
        this.setRelativeParentId(parentId);
    }

    public void setRelativeParentId(String relativeParentId) {
        this.m_relativeParentId = relativeParentId;
    }

    public String toString() {
        return "DockingState[id=" + this.m_dockableId + "; center=[" + this.centerX + "%," + this.centerY + "%]; parent=" + this.m_relativeParentId + "; region=" + this.m_region + "; ratio=" + this.m_splitRatio + "; float=" + this.m_floatingGroup + "; minimization=" + this.m_minimizedConstraint + "; ]";
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public void setCenter(Point p) {
        this.centerX = p == null ? 0 : p.x;
        this.centerY = p == null ? 0 : p.y;
    }

    public Point getCenterPoint() {
        if (this.centerX == -1 || this.centerY == -1) {
            return null;
        }
        return new Point(this.centerX, this.centerY);
    }

    public boolean hasCenterPoint() {
        return this.centerX != -1 && this.centerY != -1;
    }

    public Object clone() {
        DockingState dockingStateClone = new DockingState(this.m_dockableId);
        dockingStateClone.m_relativeParentId = this.m_relativeParentId;
        dockingStateClone.m_region = this.m_region;
        dockingStateClone.m_splitRatio = this.m_splitRatio;
        dockingStateClone.m_floatingGroup = this.m_floatingGroup;
        dockingStateClone.m_minimizedConstraint = this.m_minimizedConstraint;
        dockingStateClone.m_dockingPath = this.m_dockingPath == null ? null : (DockingPath)this.m_dockingPath.clone();
        dockingStateClone.centerX = this.centerX;
        dockingStateClone.centerY = this.centerY;
        return dockingStateClone;
    }
}

