/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.props;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.props.DockablePropertySet;
import org.flexdock.docking.props.DockingPortPropertySet;
import org.flexdock.docking.props.PropertyChangeListenerFactory;
import org.flexdock.docking.props.ScopedDockablePropertySet;
import org.flexdock.docking.props.ScopedDockingPortPropertySet;
import org.flexdock.docking.props.ScopedMap;
import org.flexdock.util.ClassMapping;
import org.flexdock.util.SwingUtility;

public class PropertyManager {
    public static final String DOCKABLE_PROPERTIES_KEY = DockablePropertySet.class.getName();
    public static final String DOCKINGPORT_PROPERTIES_KEY = DockingPortPropertySet.class.getName();
    private static final ClassMapping DOCKABLE_PROPS_MAPPING = new ClassMapping(ScopedDockablePropertySet.class, null);
    private static final HashMap DOCKABLE_CLIENT_PROPERTIES = new HashMap();

    public static DockingPortPropertySet getDockingPortRoot() {
        return ScopedDockingPortPropertySet.ROOT_PROPS;
    }

    public static DockablePropertySet getDockableRoot() {
        return ScopedDockablePropertySet.ROOT_PROPS;
    }

    public static void setDockablePropertyType(Class dockable, Class propType) {
        if (dockable == null || propType == null) {
            return;
        }
        if (!Dockable.class.isAssignableFrom(dockable) || !DockablePropertySet.class.isAssignableFrom(propType)) {
            return;
        }
        DOCKABLE_PROPS_MAPPING.addClassMapping(dockable, propType);
    }

    public static DockablePropertySet getDockablePropertySet(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Object obj = dockable.getClientProperty(DOCKABLE_PROPERTIES_KEY);
        if (!(obj instanceof DockablePropertySet)) {
            obj = PropertyManager.createDockablePropertySet(dockable);
            PropertyManager.linkPropertySet(dockable, (DockablePropertySet)obj);
        }
        return (DockablePropertySet)obj;
    }

    private static void linkPropertySet(Dockable dockable, DockablePropertySet propertySet) {
        dockable.putClientProperty(DOCKABLE_PROPERTIES_KEY, propertySet);
        PropertyChangeListener[] listeners = PropertyChangeListenerFactory.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            propertySet.addPropertyChangeListener(listeners[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePropertySet(Dockable dockable) {
        if (dockable != null) {
            dockable.putClientProperty(DOCKABLE_PROPERTIES_KEY, null);
            HashMap hashMap = DOCKABLE_CLIENT_PROPERTIES;
            synchronized (hashMap) {
                DOCKABLE_CLIENT_PROPERTIES.remove(dockable.getPersistentId());
            }
        }
    }

    public static DockingPortPropertySet getDockingPortPropertySet(DockingPort port) {
        if (port == null) {
            return null;
        }
        Object obj = port.getClientProperty(DOCKINGPORT_PROPERTIES_KEY);
        if (!(obj instanceof DockingPortPropertySet)) {
            obj = new ScopedDockingPortPropertySet(4);
            port.putClientProperty(DOCKINGPORT_PROPERTIES_KEY, obj);
        }
        return (DockingPortPropertySet)obj;
    }

    public static Object getProperty(Object key, ScopedMap map) {
        if (key == null || map == null) {
            return null;
        }
        Object value = PropertyManager.getProperty(key, map.getGlobals());
        if (value == null) {
            value = PropertyManager.getProperty(key, map.getLocals());
        }
        if (value == null) {
            value = PropertyManager.getProperty(key, map.getDefaults());
        }
        if (value == null) {
            value = PropertyManager.getProperty(key, map.getRoot());
        }
        return value;
    }

    public static Object getClientProperty(Dockable dockable, Object key) {
        if (dockable == null || key == null) {
            return null;
        }
        Component comp = dockable.getComponent();
        if (comp instanceof JComponent) {
            return SwingUtility.getClientProperty(comp, key);
        }
        return PropertyManager.getClientProperties(dockable).get(key);
    }

    public static void putClientProperty(Dockable dockable, Object key, Object value) {
        if (dockable == null || key == null) {
            return;
        }
        Component comp = dockable.getComponent();
        if (comp instanceof JComponent) {
            SwingUtility.putClientProperty(comp, key, value);
            return;
        }
        Hashtable table = PropertyManager.getClientProperties(dockable);
        if (value == null) {
            table.remove(key);
        } else {
            table.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getClientProperties(Dockable dockable) {
        String dockableId = dockable.getPersistentId();
        HashMap hashMap = DOCKABLE_CLIENT_PROPERTIES;
        synchronized (hashMap) {
            Hashtable table = (Hashtable)DOCKABLE_CLIENT_PROPERTIES.get(dockableId);
            if (table == null) {
                table = new Hashtable(2);
                DOCKABLE_CLIENT_PROPERTIES.put(dockableId, table);
            }
            return table;
        }
    }

    private static DockablePropertySet createDockablePropertySet(Dockable d) {
        Class<?> key = d.getClass();
        Class c = DOCKABLE_PROPS_MAPPING.getClassMapping(key);
        try {
            Constructor<?>[] constructors = c.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Class<?> param;
                Class<?>[] paramTypes = constructors[i].getParameterTypes();
                if (paramTypes.length != 1 || !Dockable.class.isAssignableFrom(param = paramTypes[0])) continue;
                return (DockablePropertySet)constructors[i].newInstance(d);
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static Object getProperty(Object key, Object map) {
        if (map instanceof Map) {
            return ((Map)map).get(key);
        }
        return null;
    }

    private static Object getProperty(Object key, List maps) {
        if (maps == null) {
            return null;
        }
        for (Object map : maps) {
            Object value = PropertyManager.getProperty(key, map);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

