/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.effects;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.drag.effects.DefaultPreview;
import org.flexdock.docking.drag.effects.DragPreview;
import org.flexdock.docking.drag.effects.RubberBand;
import org.flexdock.util.OsInfo;
import org.flexdock.util.ResourceManager;
import org.flexdock.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EffectsManager {
    private static final String CONFIG_URI = "org/flexdock/docking/drag/effects/drag-effects.xml";
    private static final Object LOCK = new Object();
    private static DragPreview DEFAULT_PREVIEW;
    private static DragPreview CUSTOM_PREVIEW;
    private static RubberBand DEFAULT_RUBBERBAND;
    private static RubberBand CUSTOM_RUBBERBAND;

    public static void prime() {
        Document config = ResourceManager.getDocument(CONFIG_URI);
        DEFAULT_PREVIEW = EffectsManager.loadDefaultPreview(config);
        DEFAULT_RUBBERBAND = EffectsManager.loadSystemRubberband(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubberBand getRubberBand() {
        Object object = LOCK;
        synchronized (object) {
            return CUSTOM_RUBBERBAND == null ? DEFAULT_RUBBERBAND : CUSTOM_RUBBERBAND;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DragPreview getPreview(Dockable dockable, DockingPort target) {
        Object object = LOCK;
        synchronized (object) {
            return CUSTOM_PREVIEW == null ? DEFAULT_PREVIEW : CUSTOM_PREVIEW;
        }
    }

    public static RubberBand setRubberBand(String implClass) {
        RubberBand rb = EffectsManager.createRubberBand(implClass);
        if (implClass != null && rb == null) {
            return null;
        }
        EffectsManager.setRubberBand(rb);
        return rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRubberBand(RubberBand rubberBand) {
        Object object = LOCK;
        synchronized (object) {
            CUSTOM_RUBBERBAND = rubberBand;
        }
    }

    public DragPreview setPreview(String implClass) {
        DragPreview preview = EffectsManager.createPreview(implClass);
        if (implClass != null && preview == null) {
            return null;
        }
        EffectsManager.setPreview(preview);
        return preview;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPreview(DragPreview preview) {
        Object object = LOCK;
        synchronized (object) {
            CUSTOM_PREVIEW = preview;
        }
    }

    private static final Document loadConfig() {
        return ResourceManager.getDocument(CONFIG_URI);
    }

    private static RubberBand createRubberBand(String implClass) {
        boolean failSilent = !Boolean.getBoolean("rubberband.debug");
        return (RubberBand)Utilities.createInstance(implClass, RubberBand.class, failSilent);
    }

    private static DragPreview createPreview(String implClass) {
        return (DragPreview)Utilities.createInstance(implClass, DragPreview.class);
    }

    private static HashMap loadRubberBandInfoByOS(Document config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Element root = (Element)config.getElementsByTagName("rubber-bands").item(0);
        map.put("default", root.getAttribute("default"));
        NodeList nodes = root.getElementsByTagName("os");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element osElem = (Element)nodes.item(i);
            String osName = osElem.getAttribute("name");
            NodeList items = osElem.getElementsByTagName("rubber-band");
            ArrayList<String> classes = new ArrayList<String>(items.getLength());
            map.put(osName, classes);
            for (int j = 0; j < items.getLength(); ++j) {
                Element classElem = (Element)items.item(j);
                String className = classElem.getAttribute("class");
                classes.add(className);
            }
        }
        return map;
    }

    private static RubberBand loadSystemRubberband(Document config) {
        List osList = OsInfo.getInstance().getOsNames();
        HashMap info = EffectsManager.loadRubberBandInfoByOS(config);
        for (String osName : osList) {
            List classes = (List)info.get(osName);
            if (classes == null) continue;
            for (String implClass : classes) {
                RubberBand rb = EffectsManager.createRubberBand(implClass);
                if (rb == null) continue;
                return rb;
            }
        }
        String implClass = (String)info.get("default");
        RubberBand rb = EffectsManager.createRubberBand(implClass);
        return rb == null ? new RubberBand() : rb;
    }

    private static DragPreview loadDefaultPreview(Document config) {
        Element root = (Element)config.getElementsByTagName("drag-previews").item(0);
        String previewClass = root.getAttribute("default");
        DragPreview preview = EffectsManager.createPreview(previewClass);
        if (preview != null) {
            return preview;
        }
        return new DefaultPreview(){

            public void drawPreview(Graphics2D g, Polygon poly, Dockable dockable, Map dragInfo) {
            }
        };
    }

    static {
        EffectsManager.prime();
    }
}

