/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.activation;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.util.DockingUtility;
import org.flexdock.util.RootWindow;
import org.flexdock.util.SwingUtility;

public class ActiveDockableTracker {
    public static final String CURRENT_DOCKABLE = "ActiveDockableTracker.CURRENT_DOCKABLE";
    private static final String KEY = "ActiveDockableTracker.KEY";
    private static ActiveDockableTracker currentTracker;
    private static final Object LOCK;
    private Dockable currentDockable;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private static void initialize() {
        Class<DockingManager> c = DockingManager.class;
    }

    public static ActiveDockableTracker getTracker(Component component) {
        RootWindow window = RootWindow.getRootContainer(component);
        return ActiveDockableTracker.getTracker(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActiveDockableTracker getCurrentTracker() {
        Object object = LOCK;
        synchronized (object) {
            Window window;
            if (currentTracker == null && (window = SwingUtility.getActiveWindow()) != null) {
                currentTracker = ActiveDockableTracker.getTracker(window);
            }
            return currentTracker;
        }
    }

    private static ActiveDockableTracker getTracker(RootWindow window) {
        if (window == null) {
            return null;
        }
        ActiveDockableTracker tracker = (ActiveDockableTracker)window.getClientProperty(KEY);
        if (tracker == null) {
            tracker = new ActiveDockableTracker();
            window.putClientProperty(KEY, tracker);
        }
        return tracker;
    }

    public static Dockable getActiveDockable() {
        ActiveDockableTracker tracker = ActiveDockableTracker.getCurrentTracker();
        return tracker == null ? null : tracker.currentDockable;
    }

    public static Dockable getActiveDockable(Component window) {
        ActiveDockableTracker tracker = ActiveDockableTracker.getTracker(window);
        return tracker == null ? null : tracker.currentDockable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void windowActivated(Component c) {
        RootWindow window = RootWindow.getRootContainer(c);
        ActiveDockableTracker tracker = ActiveDockableTracker.getTracker(window);
        Object object = LOCK;
        synchronized (object) {
            currentTracker = tracker;
        }
    }

    public static void requestDockableActivation(Component c) {
        ActiveDockableTracker.requestDockableActivation(c, false);
    }

    public static void requestDockableActivation(Component c, boolean forceChange) {
        if (c == null) {
            return;
        }
        Dockable dockable = DockingUtility.getAncestorDockable(c);
        if (dockable != null) {
            ActiveDockableTracker.requestDockableActivation(c, dockable, forceChange);
        }
    }

    public static void requestDockableActivation(Component c, Dockable dockable, boolean forceChange) {
        if (c == null || dockable == null) {
            return;
        }
        SwingUtility.activateWindow(c);
        ActiveDockableTracker.focusDockable(c, dockable, forceChange);
    }

    static void focusDockable(Component child, final Dockable parentDockable, boolean forceChange) {
        JTabbedPane tabPane;
        int indx;
        Component focuser;
        if (!forceChange && parentDockable.getDockingProperties().isActive().booleanValue()) {
            return;
        }
        Component parentComp = parentDockable.getComponent();
        Container focusRoot = parentComp instanceof Container ? (Container)parentComp : null;
        Component component = focuser = focusRoot == null ? null : SwingUtility.getNearestFocusableComponent(child, focusRoot);
        if (focuser == null) {
            focuser = parentComp;
        }
        if (!forceChange) {
            final Component c = focuser;
            c.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (!DockingUtility.isActive(parentDockable)) {
                        parentDockable.getDockingProperties().setActive(true);
                    }
                    c.removeFocusListener(this);
                }
            });
            c.requestFocusInWindow();
        }
        if (parentComp.getParent() instanceof JTabbedPane && (indx = (tabPane = (JTabbedPane)parentComp.getParent()).indexOfComponent(parentComp)) != tabPane.getSelectedIndex()) {
            tabPane.setSelectedIndex(indx);
        }
    }

    public void setActive(boolean b) {
        if (this.currentDockable == null || DockingManager.getDockable(this.currentDockable.getComponent()) == null) {
            return;
        }
        this.currentDockable.getDockingProperties().setActive(b);
    }

    public void setActive(Dockable dockable) {
        if (dockable != this.currentDockable) {
            Dockable oldValue = this.currentDockable;
            this.setActive(false);
            this.currentDockable = dockable;
            this.setActive(true);
            this.changeSupport.firePropertyChange(CURRENT_DOCKABLE, oldValue, dockable);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    public boolean containsPropertyChangeListener(PropertyChangeListener listener) {
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != listener) continue;
            return true;
        }
        return false;
    }

    static {
        LOCK = new Object();
        ActiveDockableTracker.initialize();
    }
}

