/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.service.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.service.DefaultServiceManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.test.RoleA;
import org.apache.avalon.framework.service.test.RoleB;

public final class DefaultServiceManagerTestCase
extends TestCase {
    private DefaultServiceManager m_componentManager;
    protected boolean m_exceptionThrown;

    public DefaultServiceManagerTestCase() {
        this("DefaultComponentManager Test Case");
    }

    public DefaultServiceManagerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.m_componentManager = new DefaultServiceManager();
        this.m_exceptionThrown = false;
    }

    protected void tearDown() throws Exception {
        this.m_componentManager = null;
    }

    public void testlookup1() throws Exception {
        DefaultRoleB roleBinBase = new DefaultRoleB();
        DefaultRoleB roleBinParent = new DefaultRoleB();
        DefaultRoleA roleAinParent = new DefaultRoleA();
        this.m_componentManager.put(RoleA.ROLE, roleAinParent);
        this.m_componentManager.put(RoleB.ROLE, roleBinParent);
        DefaultServiceManager baseComponentManager = new DefaultServiceManager(this.m_componentManager);
        baseComponentManager.put(RoleB.ROLE, roleBinBase);
        Object lookupAinBase = baseComponentManager.lookup(RoleA.ROLE);
        Object lookupBinBase = baseComponentManager.lookup(RoleB.ROLE);
        Object lookupBinParent = this.m_componentManager.lookup(RoleB.ROLE);
        Assert.assertTrue((boolean)(lookupAinBase instanceof RoleA));
        Assert.assertEquals((Object)lookupBinBase, (Object)roleBinBase);
        Assert.assertEquals((Object)lookupBinParent, (Object)roleBinParent);
        Assert.assertEquals((Object)lookupAinBase, (Object)roleAinParent);
    }

    public void testlookup2() throws Exception {
        this.m_componentManager.put(RoleA.ROLE, new DefaultRoleA());
        Object o = null;
        try {
            o = this.m_componentManager.lookup(RoleB.ROLE);
        }
        catch (ServiceException ce) {
            this.m_exceptionThrown = true;
        }
        if (o == null) {
            Assert.assertTrue((String)"ComponentException was not thrown when component was not found by lookup.", (boolean)this.m_exceptionThrown);
        } else {
            Assert.assertTrue((String)"component was found by lookup ,when there was no component.", (boolean)false);
        }
    }

    public void testhasComponent() throws Exception {
        this.m_componentManager.put(RoleA.ROLE, new DefaultRoleA());
        Assert.assertTrue((boolean)this.m_componentManager.hasService(RoleA.ROLE));
        Assert.assertTrue((!this.m_componentManager.hasService(RoleB.ROLE) ? 1 : 0) != 0);
    }

    public void testmakeReadOnly() throws Exception {
        this.m_componentManager.put(RoleA.ROLE, new DefaultRoleA());
        Object a = this.m_componentManager.lookup(RoleA.ROLE);
        Assert.assertTrue((boolean)(a instanceof RoleA));
        this.m_componentManager.makeReadOnly();
        try {
            this.m_componentManager.put(RoleB.ROLE, new DefaultRoleB());
        }
        catch (IllegalStateException se) {
            this.m_exceptionThrown = true;
        }
        Assert.assertTrue((String)"IllegalStateException was not thrown in  put after makeReadOnly.", (boolean)this.m_exceptionThrown);
    }

    class DefaultRoleB
    implements RoleB {
    }

    class DefaultRoleA
    implements RoleA {
    }
}

