/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXConfigurationHandlerTestCase
extends TestCase {
    public SAXConfigurationHandlerTestCase() {
        this("SAXConfigurationHandler Test Case ");
    }

    public SAXConfigurationHandlerTestCase(String name) {
        super(name);
    }

    public void testDefaultHandling() throws Exception {
        SAXConfigurationHandler handler = new SAXConfigurationHandler();
        String rootURI = "";
        String rootlocal = "rawName";
        String rootraw = "rawName";
        String childURI = "namespaceURI";
        String childlocal = "localName";
        String childraw = "child:localName";
        String childvalue = "value";
        String attqName = "attqName";
        String attValue = "attValue";
        String emptylocal = "emptyElement";
        String emptyraw = "emptyElement";
        AttributesImpl emptyAttributes = new AttributesImpl();
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "attqName", "attqName", "CDATA", "attValue");
        AttributesImpl childAttributes = new AttributesImpl();
        childAttributes.addAttribute("", "child", "xmlns:child", "CDATA", "namespaceURI");
        handler.startDocument();
        handler.startPrefixMapping("child", "namespaceURI");
        handler.startElement("", "rawName", "rawName", attributes);
        handler.startElement("namespaceURI", "localName", "child:localName", childAttributes);
        handler.characters("value".toCharArray(), 0, "value".length());
        handler.endElement("namespaceURI", "localName", "child:localName");
        handler.startElement("", "emptyElement", "emptyElement", emptyAttributes);
        handler.endElement("", "emptyElement", "emptyElement");
        handler.endElement(null, null, "rawName");
        handler.endPrefixMapping("child");
        handler.endDocument();
        Configuration configuration = handler.getConfiguration();
        Assert.assertEquals((String)"attValue", (String)configuration.getAttribute("attqName"));
        Assert.assertEquals((String)"value", (String)configuration.getChild("child:localName").getValue());
        Assert.assertEquals((String)"", (String)configuration.getChild("child:localName").getNamespace());
        Assert.assertEquals((String)"rawName", (String)configuration.getName());
        Assert.assertEquals((String)"test", (String)configuration.getChild("emptyElement").getValue("test"));
    }

    public void testNamespaceHandling() throws Exception {
        NamespacedSAXConfigurationHandler handler = new NamespacedSAXConfigurationHandler();
        String rootURI = "";
        String rootlocal = "rawName";
        String rootraw = "rawName";
        String childURI = "namespaceURI";
        String childlocal = "localName";
        String childraw = "child:localName";
        String childvalue = "value";
        String attqName = "attqName";
        String attValue = "attValue";
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "attqName", "attqName", "CDATA", "attValue");
        AttributesImpl childAttributes = new AttributesImpl();
        childAttributes.addAttribute("", "child", "xmlns:child", "CDATA", "namespaceURI");
        ((DefaultHandler)handler).startDocument();
        ((DefaultHandler)handler).startPrefixMapping("child", "namespaceURI");
        ((SAXConfigurationHandler)handler).startElement("", "rawName", "rawName", attributes);
        ((SAXConfigurationHandler)handler).startElement("namespaceURI", "localName", "child:localName", childAttributes);
        ((SAXConfigurationHandler)handler).characters("value".toCharArray(), 0, "value".length());
        ((SAXConfigurationHandler)handler).endElement("namespaceURI", "localName", "child:localName");
        ((SAXConfigurationHandler)handler).endElement(null, null, "rawName");
        handler.endPrefixMapping("child");
        ((DefaultHandler)handler).endDocument();
        Configuration configuration = ((SAXConfigurationHandler)handler).getConfiguration();
        Assert.assertEquals((String)"attValue", (String)configuration.getAttribute("attqName"));
        Assert.assertEquals((String)"value", (String)configuration.getChild("localName").getValue());
        Assert.assertEquals((String)"namespaceURI", (String)configuration.getChild("localName").getNamespace());
        Assert.assertEquals((String)"rawName", (String)configuration.getName());
    }
}

