/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;

public abstract class URIUtils {
    private static Boolean isWindows = null;

    public static boolean isWindows() {
        if (isWindows == null) {
            String os = System.getProperty("os.name", "unknown").toLowerCase();
            isWindows = os.contains("win");
        }
        return isWindows;
    }

    public static String windowsPathURI(String uri) {
        if (!URIUtils.isWindows()) {
            return uri;
        }
        String fixSlashes = uri.replaceAll("\\\\", "/");
        if (fixSlashes.length() >= 2 && fixSlashes.charAt(1) == ':') {
            return "file:///" + fixSlashes;
        }
        return fixSlashes;
    }

    public static URI cwd() {
        String dir = URIUtils.windowsPathURI(System.getProperty("user.dir"));
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        try {
            return URIUtils.newURI(dir);
        }
        catch (URISyntaxException ex) {
            return URI.create("file:///");
        }
    }

    public static URI newURI(String href) throws URISyntaxException {
        if (href == null) {
            return null;
        }
        if (href.startsWith("file:")) {
            int pos;
            for (pos = 5; pos <= href.length() && href.charAt(pos) == '/'; ++pos) {
            }
            if (pos > 5) {
                --pos;
            } else {
                pos = 0;
                href = "/" + href.substring(5);
            }
            if (href.contains("#")) {
                int hashpos = href.indexOf(35);
                String base = href.substring(pos, hashpos);
                String fragid = href.substring(hashpos + 1);
                return new URI("file", "", base, fragid);
            }
            return new URI("file", "", href.substring(pos), null);
        }
        if (href.startsWith("/")) {
            if (href.contains("#")) {
                int hashpos = href.indexOf(35);
                String base = href.substring(0, hashpos);
                String fragid = href.substring(hashpos + 1);
                return new URI("file", "", base, fragid);
            }
            return new URI("file", "", href, null);
        }
        return new URI(href);
    }

    public static URI resolve(URI baseURI, String uri) {
        if (baseURI == null) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException(use.getMessage(), use);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < uri.length(); ++idx) {
            char ch = uri.charAt(idx);
            if (ch <= ' ' || ch >= '~') {
                sb.append(String.format("%%%02X", ch));
                continue;
            }
            sb.append(ch);
        }
        uri = URIUtils.windowsPathURI(sb.toString());
        URI resolved = URI.create(uri);
        if (resolved.isAbsolute()) {
            return resolved;
        }
        if ("jar".equals(baseURI.getScheme())) {
            String url = baseURI.toString();
            int pos = url.lastIndexOf("!");
            if (pos > 0) {
                String prefix = url.substring(0, pos + 1);
                String path = url.substring(pos + 1);
                URI fakeURI = null;
                fakeURI = path.startsWith("/") ? URI.create("file://" + path) : URI.create("file:///" + path);
                if ((fakeURI = fakeURI.resolve(uri)).getPath().startsWith("/../")) {
                    throw new IllegalArgumentException("Attempt to navigate above root: " + prefix + fakeURI.getPath());
                }
                return URI.create(prefix + fakeURI.getPath());
            }
            return baseURI.resolve(uri);
        }
        if ("classpath".equals(baseURI.getScheme())) {
            String path = baseURI.toString().substring(10);
            URI fakeURI = null;
            fakeURI = path.startsWith("/") ? URI.create("file://" + path) : URI.create("file:///" + path);
            String cpath = (fakeURI = fakeURI.resolve(uri)).getPath().substring(1);
            if (cpath.startsWith("../")) {
                throw new IllegalArgumentException("Attempt to navigate above root: classpath:" + cpath);
            }
            return URI.create("classpath:" + cpath);
        }
        return baseURI.resolve(uri);
    }

    public static String normalizeURI(String uriref) {
        byte[] bytes;
        if (uriref == null) {
            return null;
        }
        StringBuilder newRef = new StringBuilder();
        for (byte aByte : bytes = uriref.getBytes(StandardCharsets.UTF_8)) {
            int ch = aByte & 0xFF;
            if (ch <= 32 || ch > 127 || ch == 34 || ch == 60 || ch == 62 || ch == 92 || ch == 94 || ch == 96 || ch == 123 || ch == 124 || ch == 125 || ch == 127) {
                newRef.append(URIUtils.encodedByte(ch));
                continue;
            }
            newRef.append((char)aByte);
        }
        return newRef.toString();
    }

    private static String encodedByte(int b) {
        String hex = Integer.toHexString(b).toUpperCase();
        if (hex.length() < 2) {
            return "%0" + hex;
        }
        return "%" + hex;
    }

    public static boolean forbidAccess(String allowed, String uri, boolean mergeHttps) {
        if (allowed == null || allowed.trim().isEmpty()) {
            return true;
        }
        if ("all".equals(allowed.trim())) {
            return false;
        }
        boolean sawHttp = false;
        boolean sawHttps = false;
        uri = uri.toLowerCase();
        for (String value : allowed.split(",")) {
            String protocol = value.trim().toLowerCase();
            if ("all".equals(protocol)) {
                return false;
            }
            if (!protocol.endsWith(":")) {
                protocol = protocol + ":";
            }
            sawHttp = sawHttp || "http:".equals(protocol);
            boolean bl = sawHttps = sawHttps || "https:".equals(protocol);
            if (!uri.startsWith(protocol)) continue;
            return false;
        }
        if (mergeHttps) {
            if (sawHttp && !sawHttps && uri.startsWith("https:")) {
                return false;
            }
            if (sawHttps && !sawHttp && uri.startsWith("http:")) {
                return false;
            }
        }
        return true;
    }
}

