/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.io.File;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.dsl.ReportFormat;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.NullReport;
import net.sourceforge.cobertura.reporting.Report;
import net.sourceforge.cobertura.reporting.ReportFormatStrategyRegistry;
import net.sourceforge.cobertura.reporting.ReportName;
import net.sourceforge.cobertura.util.FileFinder;

public class NativeReport
implements Report {
    private NullReport nullReport = new NullReport();
    private ProjectData projectData;
    private File destinationDir;
    private FileFinder finder;
    private ComplexityCalculator complexity;
    private String encoding;
    private ReportFormatStrategyRegistry formatStrategyRegistry;

    public NativeReport(ProjectData projectData, File destinationDir, FileFinder finder, ComplexityCalculator complexity, String encoding) {
        this.projectData = projectData;
        this.destinationDir = destinationDir;
        this.finder = finder;
        this.complexity = complexity;
        this.destinationDir = destinationDir;
        this.encoding = encoding;
        this.formatStrategyRegistry = ReportFormatStrategyRegistry.getInstance();
    }

    @Override
    public void export(ReportFormat reportFormat) {
        this.formatStrategyRegistry.getReportFormatStrategy(reportFormat).save(this);
    }

    @Override
    public ReportName getName() {
        return ReportName.COVERAGE_REPORT;
    }

    @Override
    public Report getByName(ReportName name) {
        if (this.getName().equals((Object)name)) {
            return this;
        }
        return this.nullReport;
    }

    public ProjectData getProjectData() {
        return this.projectData;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public FileFinder getFinder() {
        return this.finder;
    }

    public ComplexityCalculator getComplexity() {
        return this.complexity;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

