/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.LangElement;
import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import com.sun.java.help.impl.TagProperties;
import com.sun.java.help.impl.XmlReader;
import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.help.BadIDException;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TreeItem;
import javax.help.TreeItemFactory;
import javax.swing.tree.DefaultMutableTreeNode;

public class TOCView
extends NavigatorView {
    public static final String publicIDString = "-//Sun Microsystems Inc.//DTD JavaHelp TOC Version 1.0//EN";
    public static final String publicIDString_V2 = "-//Sun Microsystems Inc.//DTD JavaHelp TOC Version 2.0//EN";
    private Map.ID categoryOpenImageID = null;
    private Map.ID categoryClosedImageID = null;
    private Map.ID topicImageID = null;
    private static boolean warningOfFailures = false;
    private static final boolean debug = false;

    public TOCView(HelpSet hs, String name, String label, Hashtable params) {
        this(hs, name, label, hs.getLocale(), params);
    }

    public TOCView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        super(hs, name, label, locale, params);
    }

    public Component createNavigator(HelpModel model) {
        return new JHelpTOCNavigator(this, model);
    }

    public String getMergeType() {
        String mergeType = super.getMergeType();
        if (mergeType == null) {
            return "javax.help.AppendMerge";
        }
        return mergeType;
    }

    public DefaultMutableTreeNode getDataAsTree() {
        URL url;
        HelpSet hs = this.getHelpSet();
        Hashtable params = this.getParameters();
        if (params == null || params != null && !params.containsKey("data")) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            return node;
        }
        try {
            url = new URL(hs.getHelpSetURL(), (String)params.get("data"));
        }
        catch (Exception ex) {
            throw new Error("Trouble getting URL to TOC data; " + ex);
        }
        return TOCView.parse(url, hs, hs.getLocale(), new DefaultTOCFactory(), this);
    }

    public static DefaultMutableTreeNode parse(URL url, HelpSet hs, Locale locale, TreeItemFactory factory) {
        return TOCView.parse(url, hs, locale, factory, null);
    }

    public static DefaultMutableTreeNode parse(URL url, HelpSet hs, Locale locale, TreeItemFactory factory, TOCView view) {
        DefaultMutableTreeNode node = null;
        try {
            URLConnection uc = url.openConnection();
            Reader src = XmlReader.createReader(uc);
            factory.parsingStarted(url);
            TOCParser tocParser = new TOCParser(factory, view);
            node = tocParser.parse(src, hs, locale);
            src.close();
        }
        catch (Exception e) {
            factory.reportMessage("Exception caught while parsing " + url + e.toString(), false);
        }
        return factory.parsingEnded(node);
    }

    public void setCategoryOpenImageID(String imageID) {
        if (imageID == null) {
            return;
        }
        try {
            this.categoryOpenImageID = Map.ID.create(imageID, this.getHelpSet());
        }
        catch (BadIDException badIDException) {
            // empty catch block
        }
    }

    public Map.ID getCategoryOpenImageID() {
        if (this.categoryOpenImageID == null) {
            return this.categoryClosedImageID;
        }
        return this.categoryOpenImageID;
    }

    public void setCategoryClosedImageID(String imageID) {
        if (imageID == null) {
            return;
        }
        try {
            this.categoryClosedImageID = Map.ID.create(imageID, this.getHelpSet());
        }
        catch (BadIDException badIDException) {
            // empty catch block
        }
    }

    public Map.ID getCategoryClosedImageID() {
        return this.categoryClosedImageID;
    }

    public void setTopicImageID(String imageID) {
        if (imageID == null) {
            this.topicImageID = null;
            return;
        }
        try {
            this.topicImageID = Map.ID.create(imageID, this.getHelpSet());
        }
        catch (BadIDException badIDException) {
            // empty catch block
        }
    }

    public Map.ID getTopicImageID() {
        return this.topicImageID;
    }

    private static void debug(String msg) {
    }

    private static class TOCParser
    implements ParserListener {
        private HelpSet currentParseHS;
        private Stack nodeStack;
        private Stack itemStack;
        private boolean startedtoc;
        private Stack tagStack;
        private Locale defaultLocale;
        private Locale lastLocale;
        private TreeItemFactory factory;
        private TOCView tocView;

        TOCParser(TreeItemFactory factory, TOCView tocView) {
            this.factory = factory;
            this.tocView = tocView;
        }

        synchronized DefaultMutableTreeNode parse(Reader src, HelpSet context, Locale locale) throws IOException {
            this.nodeStack = new Stack();
            this.tagStack = new Stack();
            this.itemStack = new Stack();
            this.defaultLocale = locale == null ? Locale.getDefault() : locale;
            this.lastLocale = this.defaultLocale;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode();
            this.nodeStack.push(node);
            this.currentParseHS = context;
            Parser parser = new Parser(src);
            parser.addParserListener(this);
            parser.parse();
            return node;
        }

        public void tagFound(ParserEvent e) {
            Locale locale = null;
            Tag tag = e.getTag();
            TOCView.debug("TagFound: " + tag.name);
            TagProperties attr = tag.atts;
            if (attr != null) {
                String lang = attr.getProperty("xml:lang");
                locale = HelpUtilities.localeFromLang(lang);
            }
            if (locale == null) {
                locale = this.lastLocale;
            }
            if (tag.name.equals("tocitem")) {
                TOCItem item;
                if (!this.startedtoc) {
                    this.factory.reportMessage(HelpUtilities.getText("toc.invalidTOCFormat"), false);
                }
                if (tag.isEnd && !tag.isEmpty) {
                    this.nodeStack.pop();
                    this.itemStack.pop();
                    this.removeTag(tag);
                    return;
                }
                try {
                    Hashtable t = null;
                    if (attr != null) {
                        t = attr.getHashtable();
                    }
                    item = (TOCItem)this.factory.createItem("tocitem", t, this.currentParseHS, locale);
                }
                catch (Exception ex) {
                    if (warningOfFailures) {
                        String id = null;
                        String imageID = null;
                        if (attr != null) {
                            id = attr.getProperty("target");
                            imageID = attr.getProperty("image");
                        }
                        System.err.println("Failure in IndexItem Creation; ");
                        System.err.println("  id: " + id);
                        System.err.println("  hs: " + this.currentParseHS);
                    }
                    item = (TOCItem)this.factory.createItem();
                }
                if (!this.itemStack.empty()) {
                    TOCItem parent = (TOCItem)this.itemStack.peek();
                    if (item.getExpansionType() == -1 && parent != null && parent.getExpansionType() != -1) {
                        item.setExpansionType(parent.getExpansionType());
                    }
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(item);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.nodeStack.peek();
                parent.add(node);
                if (!tag.isEmpty) {
                    this.itemStack.push(item);
                    this.nodeStack.push(node);
                    this.addTag(tag, locale);
                }
            } else if (tag.name.equals("toc")) {
                TOCView.debug("attr: " + attr);
                if (!tag.isEnd) {
                    if (attr != null) {
                        String version = attr.getProperty("version");
                        if (version != null && version.compareTo("1.0") != 0 && version.compareTo("2.0") != 0) {
                            this.factory.reportMessage(HelpUtilities.getText("toc.unknownVersion", version), false);
                        }
                        if (this.tocView != null) {
                            this.tocView.setCategoryOpenImageID(attr.getProperty("categoryopenimage"));
                            this.tocView.setCategoryClosedImageID(attr.getProperty("categoryclosedimage"));
                            this.tocView.setTopicImageID(attr.getProperty("topicimage"));
                        }
                    }
                    if (this.startedtoc) {
                        this.factory.reportMessage(HelpUtilities.getText("toc.invalidTOCFormat"), false);
                    }
                    this.startedtoc = true;
                    this.addTag(tag, locale);
                } else {
                    if (this.startedtoc) {
                        this.startedtoc = false;
                    }
                    this.removeTag(tag);
                }
                return;
            }
        }

        public void piFound(ParserEvent e) {
        }

        public void doctypeFound(ParserEvent e) {
        }

        public void textFound(ParserEvent e) {
            TOCView.debug("TextFound: " + e.getText().trim());
            if (this.tagStack.empty()) {
                return;
            }
            LangElement le = (LangElement)this.tagStack.peek();
            Tag tag = le.getTag();
            if (tag.name.equals("tocitem")) {
                TOCItem item = (TOCItem)this.itemStack.peek();
                String oldName = item.getName();
                if (oldName == null) {
                    item.setName(e.getText().trim());
                } else {
                    item.setName(oldName.concat(e.getText()).trim());
                }
            }
        }

        public void commentFound(ParserEvent e) {
        }

        public void errorFound(ParserEvent e) {
            this.factory.reportMessage(e.getText(), false);
        }

        protected void addTag(Tag tag, Locale locale) {
            LangElement el = new LangElement(tag, locale);
            this.tagStack.push(el);
            if (this.lastLocale == null) {
                this.lastLocale = locale;
                return;
            }
            if (locale == null) {
                this.lastLocale = locale;
                return;
            }
            if (!this.lastLocale.equals(locale)) {
                this.lastLocale = locale;
            }
        }

        protected void removeTag(Tag tag) {
            String name = tag.name;
            Locale newLocale = null;
            while (!this.tagStack.empty()) {
                LangElement el = (LangElement)this.tagStack.pop();
                if (!el.getTag().name.equals(name)) continue;
                if (this.tagStack.empty()) {
                    newLocale = this.defaultLocale;
                    break;
                }
                el = (LangElement)this.tagStack.peek();
                newLocale = el.getLocale();
                break;
            }
            if (this.lastLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (newLocale == null) {
                this.lastLocale = newLocale;
                return;
            }
            if (!this.lastLocale.equals(newLocale)) {
                this.lastLocale = newLocale;
            }
        }
    }

    public static class DefaultTOCFactory
    implements TreeItemFactory {
        private Vector messages = new Vector();
        private URL source;
        private boolean validParse = true;

        public void parsingStarted(URL source) {
            if (source == null) {
                throw new NullPointerException("source");
            }
            this.source = source;
        }

        public void processDOCTYPE(String root, String publicID, String systemID) {
            if (publicID == null || publicID.compareTo(TOCView.publicIDString) != 0 && publicID.compareTo(TOCView.publicIDString_V2) != 0) {
                this.reportMessage(HelpUtilities.getText("toc.wrongPublicID", publicID), false);
            }
        }

        public void processPI(HelpSet hs, String target, String data) {
        }

        public TreeItem createItem(String tagName, Hashtable atts, HelpSet hs, Locale locale) {
            if (tagName == null || !tagName.equals("tocitem")) {
                throw new IllegalArgumentException("tagName");
            }
            TOCItem item = null;
            String id = null;
            String imageID = null;
            String text = null;
            String mergeType = null;
            String expand = null;
            String presentation = null;
            String presentationName = null;
            if (atts != null) {
                id = (String)atts.get("target");
                imageID = (String)atts.get("image");
                text = (String)atts.get("text");
                mergeType = (String)atts.get("mergetype");
                expand = (String)atts.get("expand");
                presentation = (String)atts.get("presentationtype");
                presentationName = (String)atts.get("presentationname");
            }
            Map.ID mapID = null;
            Map.ID imageMapID = null;
            try {
                mapID = Map.ID.create(id, hs);
            }
            catch (BadIDException bex1) {
                // empty catch block
            }
            try {
                imageMapID = Map.ID.create(imageID, hs);
            }
            catch (BadIDException bex2) {
                // empty catch block
            }
            item = new TOCItem(mapID, imageMapID, hs, locale);
            if (text != null) {
                item.setName(text);
            }
            if (mergeType != null) {
                item.setMergeType(mergeType);
            }
            if (expand != null) {
                if (expand.equals("true")) {
                    item.setExpansionType(1);
                } else if (expand.equals("false")) {
                    item.setExpansionType(0);
                }
            }
            if (presentation != null) {
                item.setPresentation(presentation);
            }
            if (presentationName != null) {
                item.setPresentationName(presentationName);
            }
            return item;
        }

        public TreeItem createItem() {
            return new TOCItem();
        }

        public void reportMessage(String msg, boolean validParse) {
            this.messages.addElement(msg);
            this.validParse = this.validParse && validParse;
        }

        public Enumeration listMessages() {
            return this.messages.elements();
        }

        public DefaultMutableTreeNode parsingEnded(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode back = node;
            if (!this.validParse) {
                back = null;
                System.err.println("Parsing failed for " + this.source);
                Enumeration e = this.messages.elements();
                while (e.hasMoreElements()) {
                    String msg = (String)e.nextElement();
                    System.err.println(msg);
                }
            }
            return back;
        }
    }
}

