/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidNavigatorViewException;
import javax.help.Map;

public abstract class NavigatorView
implements Serializable {
    private HelpSet hs;
    private String name;
    private String label;
    private Locale locale;
    private Hashtable params;
    private Map.ID imageID;
    private String mergeType;

    protected NavigatorView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        if (name == null || label == null) {
            throw new NullPointerException("Invalid name or label");
        }
        this.imageID = null;
        if (params != null) {
            String imageID = (String)params.get("imageID");
            if (imageID != null) {
                this.imageID = Map.ID.create(imageID, hs);
            }
            this.mergeType = (String)params.get("mergetype");
        }
        this.hs = hs;
        this.name = name;
        this.label = label;
        this.locale = locale;
        this.params = params;
    }

    public static NavigatorView create(HelpSet hs, String name, String label, Locale locale, String className, Hashtable params) throws InvalidNavigatorViewException {
        try {
            ClassLoader loader = hs.getLoader();
            Class[] types = new Class[]{HelpSet.class, String.class, String.class, Locale.class, Hashtable.class};
            Object[] args = new Object[]{hs, name, label, locale, params};
            Class<?> klass = loader == null ? Class.forName(className) : loader.loadClass(className);
            Constructor<?> konstructor = klass.getConstructor(types);
            NavigatorView back = (NavigatorView)konstructor.newInstance(args);
            return back;
        }
        catch (Exception ex) {
            throw new InvalidNavigatorViewException("Could not create", hs, name, label, locale, className, params);
        }
    }

    public abstract Component createNavigator(HelpModel var1);

    public HelpSet getHelpSet() {
        return this.hs;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel(Locale locale) {
        return this.getLabel();
    }

    public String getLabel() {
        return this.label;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Hashtable getParameters() {
        return this.params;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public Map.ID getImageID() {
        return this.imageID;
    }
}

