/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidNavigatorViewException;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.help.SearchView;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;

public class JHelpSearchNavigator
extends JHelpNavigator {
    private MergingSearchEngine search;
    private static final boolean debug = false;

    public JHelpSearchNavigator(NavigatorView view) {
        super(view, null);
    }

    public JHelpSearchNavigator(NavigatorView view, HelpModel model) {
        super(view, model);
    }

    public JHelpSearchNavigator(HelpSet hs, String name, String label, URL data) throws InvalidNavigatorViewException {
        super(new SearchView(hs, name, label, JHelpSearchNavigator.createParams(data)));
    }

    public String getUIClassID() {
        return "HelpSearchNavigatorUI";
    }

    public SearchEngine getSearchEngine() {
        if (this.search == null) {
            this.search = new MergingSearchEngine(this.getNavigatorView());
        }
        return this.search;
    }

    public void setSearchEngine(SearchEngine search) {
        this.search = new MergingSearchEngine(search);
    }

    protected String getDefaultQueryEngine() {
        return HelpUtilities.getDefaultQueryEngine();
    }

    public boolean canMerge(NavigatorView view) {
        if (view instanceof SearchView && this.getNavigatorName().equals(view.getName())) {
            JHelpSearchNavigator.debug("canMerge: true");
            return true;
        }
        JHelpSearchNavigator.debug("canMerge: false");
        return false;
    }

    public void merge(NavigatorView view) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.merge invoked");
        JHelpSearchNavigator.debug("  params: " + view.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.merge(view);
        JHelpSearchNavigator.debug("merge: " + view);
        this.getUI().merge(view);
    }

    public void remove(NavigatorView view) {
        JHelpSearchNavigator.debug("JHelpSearchNavigator.remove invoked");
        JHelpSearchNavigator.debug("  params: " + view.getParameters());
        if (this.search == null) {
            this.search = (MergingSearchEngine)this.getSearchEngine();
        }
        this.search.remove(view);
        JHelpSearchNavigator.debug("remove: " + view);
        this.getUI().remove(view);
    }

    private static void debug(String msg) {
    }
}

