/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.ConceptGroupGenerator;
import com.sun.java.help.search.GeneratorHeap;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.NextDocGenerator;
import com.sun.java.help.search.NextDocGeneratorHeap;
import com.sun.java.help.search.Query;
import com.sun.java.help.search.RoleFiller;
import com.sun.java.help.search.SearchEnvironment;
import javax.help.search.SearchQuery;

class Search {
    private static final int InitNConcepts = 128;
    private SearchEnvironment _env;
    private int _max;
    private int _nConcepts;
    private int _nQueries;
    private ConceptGroupGenerator _firstGenerator = new ConceptGroupGenerator();
    private int[] _concepts = new int[16];
    private int _free2;
    private int _size2;
    private int _startingIndex = 0;
    private int _limit = 0;
    private Query[] _query;
    private ConceptData[] _conceptData;
    private GeneratorHeap _genHeap = new GeneratorHeap();
    private int _document;
    private byte[] _data = null;
    private int _base = 0;
    private NextDocGeneratorHeap _nextDocGenHeap = new NextDocGeneratorHeap();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _offsets = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _docConcepts = new IntegerArray();
    private IntegerArray _queryMasks = new IntegerArray();
    private int _maxHitsToShow = 100;

    public Search(SearchEnvironment se, int nColumns) {
        this._env = se;
        this._nQueries = 1;
        this._query = new Query[this._nQueries];
        this._size2 = 128;
        this._free2 = 0;
        this._conceptData = new ConceptData[this._size2];
        this._query[0] = new Query(se, nColumns, null);
    }

    public void addTerm(int col, int concept, double score, int query) {
        if (this._env.occursInText(concept)) {
            if (this._free2 == this._size2) {
                ConceptData[] newArray = new ConceptData[this._size2 *= 2];
                System.arraycopy(this._conceptData, 0, newArray, 0, this._free2);
                this._conceptData = newArray;
            }
            this._conceptData[this._free2++] = new ConceptData(concept, col, score, query, this._query[query].getNColumns());
        }
    }

    public void startSearch(SearchQuery searchQuery) {
        int j;
        this.quicksort(0, this._free2 - 1);
        int i = 0;
        while (i < this._free2 - 1) {
            for (j = i + 1; j < this._free2; ++j) {
                if (this._conceptData[i].crqEquals(this._conceptData[j])) {
                    this._conceptData[j] = null;
                    continue;
                }
                i = j;
            }
            i = j;
        }
        i = 0;
        while (i < this._free2 - 1) {
            for (j = i + 1; j < this._free2; ++j) {
                if (this._conceptData[j] == null) continue;
                if (this._conceptData[i].cEquals(this._conceptData[j])) {
                    this._conceptData[i].addLast(this._conceptData[j]);
                    this._conceptData[j] = null;
                    continue;
                }
                i = j;
            }
            i = j;
        }
        block6: for (i = 0; i < this._free2 - 1; ++i) {
            if (this._conceptData[i] != null) continue;
            for (j = i + 1; j < this._free2; ++j) {
                if (this._conceptData[j] == null) continue;
                this._conceptData[i] = this._conceptData[j];
                this._conceptData[j] = null;
                continue block6;
            }
        }
        this._nextDocGenHeap.reset();
        for (i = 0; i < this._free2 && this._conceptData[i] != null; ++i) {
            NextDocGenerator gen = new NextDocGenerator(this._conceptData[i], this._env);
            try {
                gen.first();
                if (gen.getDocument() == -1) continue;
                this._conceptData[i].setConceptLength(this._env.getConceptLength(this._conceptData[i].getConcept()));
                this._nextDocGenHeap.addGenerator(gen);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._nextDocGenHeap.start();
        this.searchDocument();
        if (searchQuery == null) {
            this.printResults(this._maxHitsToShow);
        } else {
            this._query[0].makeEvent(this._maxHitsToShow, searchQuery);
        }
    }

    private void searchDocument() {
        RoleFiller[] start = new RoleFiller[this._nQueries];
        do {
            try {
                switch (this.nextDocument(start)) {
                    case 0: {
                        this._genHeap.start(start);
                        while (this._genHeap.next(start)) {
                        }
                        break;
                    }
                    case 1: {
                        if (!this._firstGenerator.next()) break;
                        this._firstGenerator.generateFillers(start);
                        while (this._firstGenerator.next()) {
                            this._firstGenerator.generateFillers(start);
                        }
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                continue;
            }
            for (int i = 0; i < this._nQueries; ++i) {
                RoleFiller next = start[i];
                if (next == null || next == RoleFiller.STOP) continue;
                next.scoreList(this._query[i], this._document);
            }
            this._genHeap.reset();
        } while (this._nextDocGenHeap.isNonEmpty());
    }

    private int indexOf(int concept) throws Exception {
        int i = this._startingIndex;
        int j = this._nConcepts;
        while (i <= j) {
            int k = (i + j) / 2;
            if (this._concepts[k] < concept) {
                i = k + 1;
                continue;
            }
            if (concept < this._concepts[k]) {
                j = k - 1;
                continue;
            }
            this._startingIndex = k + 1;
            return k;
        }
        throw new Exception("indexOf " + concept + " not found");
    }

    private void printResults(int nHits) {
        for (int q = 0; q < this._nQueries; ++q) {
            System.out.println("query " + q);
            if (this._query[q] == null) continue;
            this._query[q].printHits(nHits);
        }
    }

    private ConceptGroupGenerator makeGenerator(int group) throws Exception {
        int shift;
        int index;
        if (group > 0) {
            index = this._base + this._offsets.at(group - 1);
            shift = this._maxConcepts.at(group - 1);
        } else {
            index = this._base;
            shift = 0;
        }
        ConceptGroupGenerator gen = new ConceptGroupGenerator(this._data, index, this._kTable.at(2 * group + 1));
        this._nConcepts = gen.decodeConcepts(this._kTable.at(2 * group), shift, this._concepts);
        this._max = group < this._limit ? (this._concepts[this._nConcepts] = this._maxConcepts.at(group)) : this._concepts[this._nConcepts - 1];
        this._genHeap.addGenerator(gen);
        this._startingIndex = 0;
        return gen;
    }

    private boolean openDocumentIndex(int docID) throws Exception {
        this._data = this._env.getPositions(docID);
        this._base = 0;
        this._startingIndex = 0;
        int kk = this._data[this._base] & 0xFF;
        switch (kk >> 6) {
            case 0: {
                byte k2 = this._data[this._base + 1];
                this._firstGenerator.init(this._data, this._base += 2, k2);
                this._nConcepts = this._firstGenerator.decodeConcepts(kk & 0x3F, 0, this._concepts);
                return false;
            }
            case 2: {
                this._kTable.clear();
                this._offsets.clear();
                this._maxConcepts.clear();
                ByteArrayDecompressor compr = new ByteArrayDecompressor(this._data, this._base + 1);
                compr.decode(kk & 0x3F, this._kTable);
                compr.ascDecode(this._kTable.popLast(), this._offsets);
                compr.ascDecode(this._kTable.popLast(), this._maxConcepts);
                this._base += 1 + compr.bytesRead();
                this._limit = this._maxConcepts.cardinality();
                return true;
            }
            case 1: 
            case 3: {
                throw new Exception("extents not yet implemented\n");
            }
        }
        return false;
    }

    private int nextDocument(RoleFiller[] start) throws Exception {
        while (this._nextDocGenHeap.isNonEmpty()) {
            for (int i = 0; i < this._nQueries; ++i) {
                if (this._query[i] == null) continue;
                this._query[i].resetForNextDocument();
            }
            int index = 0;
            this._document = this._nextDocGenHeap.getDocument();
            this._docConcepts.clear();
            this._queryMasks.clear();
            do {
                this._docConcepts.add(this._nextDocGenHeap.getConcept());
                this._queryMasks.add(this._nextDocGenHeap.getQueryMask());
                int n = index++;
                ConceptData conceptData = this._nextDocGenHeap.getTerms();
                this._conceptData[n] = conceptData;
                conceptData.runBy(this._query);
                this._nextDocGenHeap.step();
            } while (this._nextDocGenHeap.atDocument(this._document));
            int voteMask = 0;
            for (int i = 0; i < this._nQueries; ++i) {
                if (this._query[i] == null) continue;
                if (this._query[i].vote()) {
                    start[i] = null;
                    voteMask |= 1 << i;
                    continue;
                }
                start[i] = RoleFiller.STOP;
            }
            if (voteMask == 0) continue;
            if (this.openDocumentIndex(this._document)) {
                int i = 0;
                while ((this._queryMasks.at(i) & voteMask) == 0) {
                    ++i;
                }
                int c = this._docConcepts.at(i);
                int group = 0;
                while (c > this._maxConcepts.at(group) && ++group < this._limit) {
                }
                ConceptGroupGenerator gen = this.makeGenerator(group);
                gen.addTerms(this.indexOf(c), this._conceptData[i]);
                ++i;
                while (i < index) {
                    if ((this._queryMasks.at(i) & voteMask) > 0) {
                        c = this._docConcepts.at(i);
                        if (c > this._max) {
                            while (c > this._maxConcepts.at(group) && ++group < this._limit) {
                            }
                            gen = this.makeGenerator(group);
                        }
                        gen.addTerms(this.indexOf(c), this._conceptData[i]);
                    }
                    ++i;
                }
                return 0;
            }
            for (int i = 0; i < index; ++i) {
                if ((this._queryMasks.at(i) & voteMask) == 0) continue;
                this._firstGenerator.addTerms(this.indexOf(this._docConcepts.at(i)), this._conceptData[i]);
            }
            return 1;
        }
        return 2;
    }

    private int partition(int p, int r) {
        ConceptData x = this._conceptData[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (x.compareWith(this._conceptData[--j])) {
                continue;
            }
            while (this._conceptData[++i].compareWith(x)) {
            }
            if (i >= j) break;
            ConceptData t = this._conceptData[i];
            this._conceptData[i] = this._conceptData[j];
            this._conceptData[j] = t;
        }
        return j;
    }

    private void quicksort(int p, int r) {
        if (p < r) {
            int q = this.partition(p, r);
            this.quicksort(p, q);
            this.quicksort(q + 1, r);
        }
    }
}

