/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.impl.HeaderParser;
import com.sun.java.help.search.ChangedCharSetException;
import com.sun.java.help.search.DefaultIndexBuilder;
import com.sun.java.help.search.DefaultIndexerKit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.help.search.ConfigFile;
import javax.help.search.IndexerKit;

public class Indexer {
    String dbName = "JavaHelpSearch";
    PrintStream verbose = null;
    PrintStream logStream = null;
    short docNumber;
    private DefaultIndexBuilder indexBuilder = null;
    private ConfigFile config;
    private String title;
    private String header;
    private boolean firstHeader = false;
    String lastPCdata;
    int currentPos;
    boolean openTagSeen = false;
    boolean inPre = false;
    boolean inTitle = false;
    boolean inFirstHeader = false;
    boolean inOption = false;
    int inBlock = 0;
    String sourcepath;
    private IndexerKit kit;
    private Hashtable typeHandlers;
    private String defaultCharSetName = "ISO8859_1";
    private String charSetName;
    private String defaultLang = Locale.getDefault().toString();
    private String lang;
    private static final Hashtable kitRegistry = new Hashtable();
    private static final Hashtable kitTypeRegistry = new Hashtable();
    private static final Hashtable kitLoaderRegistry = new Hashtable();
    private static boolean debugFlag;

    public static void main(String[] args) throws Exception {
        Indexer compiler = new Indexer();
        compiler.compile(args);
    }

    public Indexer() {
        if (this.dbName.lastIndexOf("/") != this.dbName.length() - 1) {
            this.dbName = this.dbName.concat("/");
        }
        this.docNumber = 0;
    }

    public void compile(String[] args) throws Exception {
        int i;
        long startTime = System.currentTimeMillis();
        String configFile = null;
        Vector<String> tmpfiles = new Vector<String>();
        Vector files = new Vector();
        this.sourcepath = "";
        boolean nostopwords = false;
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-db")) {
                if (i + 1 < args.length) {
                    this.dbName = args[++i];
                    if (this.dbName.lastIndexOf("/") == this.dbName.length() - 1) continue;
                    this.dbName = this.dbName.concat("/");
                    continue;
                }
                System.out.println(args[i] + "-db requires argument");
                continue;
            }
            if (args[i].equals("-sourcepath")) {
                if (i + 1 < args.length) {
                    this.sourcepath = args[++i];
                    continue;
                }
                System.out.println(args[i] + "-sourcepath requires argument");
                continue;
            }
            if (args[i].equals("-locale")) {
                if (i + 1 < args.length) {
                    this.defaultLang = args[++i];
                    continue;
                }
                System.out.println(args[i] + "-locale requires argument");
                continue;
            }
            if (args[i].equals("-logfile")) {
                if (i + 1 < args.length) {
                    String logFile = args[++i];
                    try {
                        this.logStream = new PrintStream(new FileOutputStream(logFile), true);
                        System.setErr(this.logStream);
                        System.setOut(this.logStream);
                        this.verbose = this.logStream;
                    }
                    catch (FileNotFoundException ex) {
                        System.out.println("Couldn't create logFile " + logFile);
                    }
                    continue;
                }
                System.out.println(args[i] + "-logfile requires argument");
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.verbose = System.out;
                continue;
            }
            if (args[i].equals("-nostopwords")) {
                nostopwords = true;
                continue;
            }
            if (args[i].equals("-c")) {
                if (i + 1 < args.length) {
                    configFile = args[++i];
                    continue;
                }
                System.out.println(args[i] + "-c requires argument");
                continue;
            }
            if (args[i].startsWith("-")) {
                System.out.println("Unknown argument '" + args[i] + "'");
                this.showUsage();
                return;
            }
            tmpfiles.addElement(args[i]);
        }
        this.config = new ConfigFile(configFile, files, nostopwords);
        files = this.config.getFiles();
        int size = tmpfiles.size();
        for (i = 0; i < size; ++i) {
            files = this.loadFiles((String)tmpfiles.elementAt(i), files);
        }
        size = files.size();
        if (size == 0) {
            System.out.println("No files specified to index");
            this.showUsage();
            return;
        }
        this.indexBuilder = new DefaultIndexBuilder(this.dbName);
        this.indexBuilder.storeStopWords(this.config.getStopWords());
        for (i = 0; i < size; ++i) {
            String file = (String)files.elementAt(i);
            URL url = new URL("file", "", this.sourcepath + file);
            InputStream in = url.openStream();
            URLConnection conn = url.openConnection();
            String type = conn.getContentType();
            this.setContentType(type);
            if (this.kit == null) continue;
            try {
                if (this.verbose != null) {
                    this.verbose.println("   File: '" + file + "'");
                    this.verbose.println("    URL: '" + this.config.getURLString(file) + "'");
                }
                this.parseFile(in, file, false);
                in.close();
                continue;
            }
            catch (UnsupportedEncodingException e1) {
                System.out.println("File: '" + file + "' encoding " + this.charSetName + " not supported");
                in.close();
                continue;
            }
            catch (IOException e) {
                if (debugFlag) {
                    e.printStackTrace();
                }
                System.out.println("I/O exception occurred in file '" + this.sourcepath + file + "'");
                in.close();
            }
        }
        long parseTime = System.currentTimeMillis() - startTime;
        long compileTime = System.currentTimeMillis() - startTime - parseTime;
        if (this.verbose != null) {
            this.verbose.println("        Parse time: " + (double)parseTime / 1000.0 + " s");
        }
        this.indexBuilder.close();
    }

    void parseFile(InputStream in, String file, boolean ignoreCharset) throws IOException {
        try {
            this.kit.parse(new InputStreamReader(in, this.charSetName), file, ignoreCharset, this.indexBuilder, this.config);
        }
        catch (ChangedCharSetException e1) {
            String charSetSpec = e1.getCharSetSpec();
            if (e1.keyEqualsCharSet()) {
                this.charSetName = charSetSpec;
            } else {
                this.setCharsetFromContentTypeParameters(charSetSpec);
            }
            in.close();
            URL url = new URL("file", "", this.sourcepath + file);
            in = url.openStream();
            this.parseFile(in, file, true);
        }
    }

    public Vector loadFiles(String file, Vector files) {
        File tstfile = new File(file);
        if (tstfile.isDirectory()) {
            String[] list = tstfile.list();
            for (int i = 0; i < list.length; ++i) {
                files = this.loadFiles(tstfile.getPath() + File.separator + list[i], files);
            }
        } else {
            files.addElement(file);
        }
        return files;
    }

    public void showUsage() {
        System.out.println(" Usage:   java JavaHelp.Index options file ...");
        System.out.println(" Options: -c file   config file");
        System.out.println("          -db file  generated database file name");
        System.out.println("          -verbose  verbose documentation");
        System.out.println("          -nostopwords ignore stop words");
        System.out.println("          -locale language_country_variant");
        System.out.println("          -logfile log file name");
        System.out.println("Note: config file composition:");
        System.out.println("          IndexRemove /public_html/JavaHelp/demo");
        System.out.println("          IndexPrepend ..");
        System.out.println("          StopWords word1 ... wordN");
        System.out.println("          StopWordsFile stopWordFileName");
        System.out.println("          File /public_html/JavaHelp/demo/first.html");
        System.out.println("          File=/public_html/JavaHelp/demo/second.html");
        System.out.println("          ...");
    }

    public final void setContentType(String type) {
        IndexerKit k;
        this.charSetName = this.defaultCharSetName;
        this.lang = this.defaultLang;
        Indexer.debug("type=" + type);
        int parm = type.indexOf(";");
        if (parm > -1) {
            String paramList = type.substring(parm);
            type = type.substring(0, parm).trim();
            this.setCharsetFromContentTypeParameters(paramList);
        }
        if (!(this.kit != null && type.equals(this.kit.getContentType()) || (k = this.getIndexerKitForContentType(type)) == null)) {
            this.kit = k;
        }
        this.kit.setLocale(this.lang);
    }

    private void setCharsetFromContentTypeParameters(String paramlist) {
        String charset = null;
        try {
            HeaderParser hdrParser;
            int semi = paramlist.indexOf(59);
            if (semi > -1 && semi < paramlist.length() - 1) {
                paramlist = paramlist.substring(semi + 1);
            }
            if (paramlist.length() > 0 && (charset = (hdrParser = new HeaderParser(paramlist)).findValue("charset")) != null) {
                this.charSetName = charset;
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            System.err.println("Indexer.getCharsetFromContentTypeParameters failed on: " + paramlist);
            e.printStackTrace();
        }
    }

    public IndexerKit getIndexerKitForContentType(String type) {
        IndexerKit k;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((k = (IndexerKit)this.typeHandlers.get(type)) == null && (k = Indexer.createIndexerKitForContentType(type)) != null) {
            this.setIndexerKitForContentType(type, k);
        }
        if (k == null) {
            k = new DefaultIndexerKit();
            this.setIndexerKitForContentType(type, k);
        }
        return k;
    }

    public void setIndexerKitForContentType(String type, IndexerKit k) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(type, k);
    }

    public static IndexerKit createIndexerKitForContentType(String type) {
        Indexer.debug("Getting IndexerKit for " + type);
        IndexerKit k = null;
        k = (IndexerKit)kitRegistry.get(type);
        if (k == null) {
            String classname = (String)kitTypeRegistry.get(type);
            ClassLoader loader = (ClassLoader)kitLoaderRegistry.get(type);
            try {
                Class<?> c = loader != null ? loader.loadClass(classname) : Class.forName(classname);
                k = (IndexerKit)c.newInstance();
                kitRegistry.put(type, k);
            }
            catch (Throwable e) {
                if (debugFlag) {
                    e.printStackTrace();
                }
                k = null;
            }
        }
        if (k != null) {
            return (IndexerKit)k.clone();
        }
        return null;
    }

    public static void registerIndexerKitForContentType(String type, String classname, ClassLoader loader) {
        kitTypeRegistry.put(type, classname);
        if (loader != null) {
            kitLoaderRegistry.put(type, loader);
        }
    }

    private static void debug(String str) {
        if (debugFlag) {
            System.out.println("Indexer: " + str);
        }
    }

    static {
        Indexer.registerIndexerKitForContentType("text/plain", "com.sun.java.help.search.PlainTextIndexerKit", null);
        Indexer.registerIndexerKitForContentType("text/html", "com.sun.java.help.search.HTMLIndexerKit", null);
        debugFlag = false;
    }
}

