/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.TreeItem;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.text.BoxView;
import javax.swing.text.EditorKit;
import javax.swing.text.View;

public class JHelpPrintHandler
implements ActionListener {
    public static final String PRINT_BUTTON_NAME = "PrintButton";
    public static final String PAGE_SETUP_BUTTON_NAME = "PageSetupButton";
    public static final String PRINT_LATER_BUTTON_NAME = "PrintLaterButton";
    private boolean enabled = true;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private JHelp help;
    private HelpModel helpModel;
    private URL documentURL;
    private String documentTitle;
    private static WeakHashMap handlers;
    protected SwingPropertyChangeSupport changeSupport;
    private static final boolean debug = false;

    public JHelpPrintHandler(JHelp help) {
        this.help = help;
    }

    public static JHelpPrintHandler getJHelpPrintHandler(JHelp help) {
        JHelpPrintHandler handler = null;
        if (handlers == null) {
            handlers = new WeakHashMap();
        } else {
            handler = (JHelpPrintHandler)handlers.get(help);
        }
        if (handler == null) {
            handler = new JHelpPrintHandler(help);
            handlers.put(help, handler);
        }
        return handler;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", new Boolean(oldValue), new Boolean(newValue));
    }

    public void actionPerformed(ActionEvent e) {
        String name = null;
        Object source = e.getSource();
        if (source instanceof MenuComponent) {
            name = ((MenuComponent)source).getName();
        }
        if (source instanceof Component) {
            name = ((Component)source).getName();
        }
        if (this.isEnabled()) {
            if (name != null && name.equals(PAGE_SETUP_BUTTON_NAME)) {
                this.printSetup();
            } else if (this.getHelp() != null) {
                this.print(this.getURLs());
            } else if (this.getHelpModel() != null) {
                this.print(this.getHelpModel().getCurrentURL());
            }
        }
    }

    public void printSetup() {
        if (this.isEnabled()) {
            new PageSetupThread().start();
        }
    }

    public void print(URL url) {
        if (this.isEnabled()) {
            new PrintThread(url).start();
        }
    }

    public void print(URL[] urls) {
        if (this.isEnabled()) {
            new PrintThread(urls).start();
        }
    }

    private JHelp getHelp() {
        return this.help;
    }

    private URL[] getURLs() {
        TreeItem[] items;
        URL[] urls = null;
        if (this.getHelp() != null && (items = this.getHelp().getSelectedItems()) != null) {
            JHelpPrintHandler.debug("pages to print: " + items.length);
            urls = new URL[items.length];
            for (int i = 0; i < items.length; ++i) {
                JHelpPrintHandler.debug("   " + items[i].getName() + ": " + items[i].getURL());
                urls[i] = items[i].getURL();
            }
        }
        return urls;
    }

    public PageFormat getPageFormat() {
        if (this.pageFormat == null && this.getPrinterJob() != null) {
            this.pageFormat = this.getPrinterJob().defaultPage();
        }
        return this.pageFormat;
    }

    public PageFormat getPF() {
        return this.getPageFormat();
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (this.pageFormat == pageFormat) {
            return;
        }
        PageFormat oldPageFormat = this.pageFormat;
        this.pageFormat = pageFormat;
        this.firePropertyChange("pageFormat", oldPageFormat, pageFormat);
    }

    public void setPF(PageFormat pf) {
        this.setPageFormat(pf);
    }

    public PrinterJob getPrinterJob() {
        if (this.printerJob == null) {
            try {
                this.printerJob = PrinterJob.getPrinterJob();
            }
            catch (SecurityException se) {
                this.setEnabled(false);
                JHelpPrintHandler.processException(se);
            }
        }
        return this.printerJob;
    }

    public void handlePageSetup(Component psComp) {
        psComp.setName(PAGE_SETUP_BUTTON_NAME);
    }

    public void setHelpModel(HelpModel helpModel) {
        HelpModel oldModel = this.helpModel;
        this.helpModel = helpModel;
        this.firePropertyChange("helpModel", oldModel, helpModel);
    }

    public HelpModel getHelpModel() {
        return this.helpModel;
    }

    static Window getWindowForObject(Object comp) {
        if (comp == null || comp instanceof Frame || comp instanceof Dialog) {
            return (Window)comp;
        }
        MenuContainer parent = null;
        if (comp instanceof MenuComponent) {
            parent = ((MenuComponent)comp).getParent();
        } else if (comp instanceof Component) {
            parent = ((Component)comp).getParent();
        }
        return JHelpPrintHandler.getWindowForObject(parent);
    }

    static Insets getInsetsForContainer(Container c) {
        Insets i = c.getInsets();
        for (c = c.getParent(); c != null; c = c.getParent()) {
            Insets ii = c.getInsets();
            i.bottom += ii.bottom;
            i.left += ii.left;
            i.right += ii.right;
            i.top += ii.top;
            if (c instanceof Window) break;
        }
        return i;
    }

    EditorKit createEditorKitForContentType(String type) {
        HelpModel model = null;
        JHelp help = this.getHelp();
        model = help != null ? help.getModel() : this.getHelpModel();
        if (model == null) {
            return null;
        }
        HelpSet hs = model.getHelpSet();
        if (hs == null) {
            return null;
        }
        String classname = (String)hs.getKeyData(HelpSet.kitTypeRegistry, type);
        if (classname == null) {
            return null;
        }
        ClassLoader loader = (ClassLoader)hs.getKeyData(HelpSet.kitLoaderRegistry, type);
        if (loader == null) {
            loader = hs.getLoader();
        }
        EditorKit k = null;
        try {
            Class<?> c = loader != null ? loader.loadClass(classname) : Class.forName(classname);
            k = (EditorKit)c.newInstance();
        }
        catch (Throwable e) {
            System.err.println(e);
            k = null;
        }
        if (k != null) {
            return (EditorKit)k.clone();
        }
        return k;
    }

    protected static Rectangle getViewRec(View rootview, float width, float height) {
        Rectangle r = new Rectangle();
        rootview.setSize(width, height);
        r.width = (int)Math.max((long)Math.ceil(rootview.getMinimumSpan(0)), (long)width);
        r.height = (int)Math.min((long)Math.ceil(rootview.getPreferredSpan(1)), Integer.MAX_VALUE);
        rootview.setSize(r.width, r.height);
        if (rootview.getView(0) instanceof BoxView) {
            BoxView box = (BoxView)rootview.getView(0);
            r.width = box.getWidth();
            r.height = box.getHeight();
        } else {
            r.height = (int)Math.min((long)Math.ceil(rootview.getPreferredSpan(1)), Integer.MAX_VALUE);
        }
        return r;
    }

    protected static void processException(Exception e) {
        System.err.println(e);
    }

    private static void debug(String str) {
    }

    class JHEditorPane
    extends JEditorPane {
        public JHEditorPane() {
            this.setDoubleBuffered(false);
            this.setEditable(false);
            this.setDropTarget(null);
        }

        public EditorKit getEditorKitForContentType(String type) {
            EditorKit k = JHelpPrintHandler.this.createEditorKitForContentType(type);
            if (k == null) {
                k = super.getEditorKitForContentType(type);
            }
            return k;
        }

        public void addMouseListener(MouseListener l) {
        }

        public void removeMouseListener(MouseListener l) {
        }

        public void addMouseMotionListener(MouseMotionListener l) {
        }

        public void removeMouseMotionListener(MouseMotionListener l) {
        }

        public void addFocusListener(FocusListener l) {
        }

        public void removeFocusListener(FocusListener l) {
        }

        public void addKeyListener(KeyListener l) {
        }

        public void removeKeyListener(KeyListener l) {
        }
    }

    class JHFrame
    extends JFrame {
        JHFrame() {
        }

        public void addNotify() {
            this.getRootPane().addNotify();
        }

        public void validate() {
            this.validateTree();
        }

        public Graphics getGraphics() {
            return JHelpPrintHandler.this.getHelp().getGraphics();
        }
    }

    public class JHPageable
    implements Pageable {
        private JEditorPane editor;
        private URL[] urls;
        private PageFormat pf;
        private int lastIndex = -1;
        private int lastPage = 0;
        private Printable printable = new EmptyPrintable();
        private int numPages = 0;

        public JHPageable(JEditorPane editor, URL[] urls, PageFormat pf) {
            this.editor = editor;
            this.urls = urls;
            this.pf = pf;
        }

        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            return this.pf;
        }

        public int getNumberOfPages() {
            if (this.numPages != 0) {
                return this.numPages;
            }
            if (this.urls != null) {
                for (int i = 0; i < this.urls.length; ++i) {
                    JHPrintable printable = new JHPrintable(this.editor, this.urls[i], this.pf, 0, true);
                    this.numPages += printable.getNumberOfPages();
                }
            }
            return this.numPages;
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            JHelpPrintHandler.debug("JHPageable.getPrintable(" + pageIndex + "): lastIndex=" + this.lastIndex + ", lastPage" + this.lastPage);
            if (pageIndex < 0) {
                throw new IndexOutOfBoundsException(pageIndex + " < 0");
            }
            if (this.urls != null) {
                while (pageIndex >= this.lastPage && this.lastIndex + 1 < this.urls.length) {
                    if (this.urls[++this.lastIndex] != null) {
                        this.printable = new JHPrintable(this.editor, this.urls[this.lastIndex], this.pf, this.lastPage, true);
                        this.lastPage += ((JHPrintable)this.printable).getNumberOfPages();
                        continue;
                    }
                    this.printable = new EmptyPrintable();
                }
            }
            if (pageIndex > this.lastPage) {
                throw new IndexOutOfBoundsException(pageIndex + " > " + this.lastPage);
            }
            return this.printable;
        }
    }

    class EmptyPrintable
    implements Printable {
        EmptyPrintable() {
        }

        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            return 1;
        }
    }

    class JHPrintable
    implements Printable,
    PropertyChangeListener {
        JEditorPane editor;
        URL url;
        PageFormat pf;
        int firstPage;
        boolean scaleToFit;
        Vector transforms;

        public JHPrintable(JEditorPane editor, URL url, PageFormat pf, int firstPage, boolean scaleToFit) {
            this.editor = editor;
            this.url = url;
            this.pf = pf;
            this.firstPage = firstPage;
            this.scaleToFit = scaleToFit;
        }

        private synchronized void loadPage() {
            JHelpPrintHandler.debug("JHPrintable.loadPage(): " + this.url);
            URL currentURL = this.editor.getPage();
            if (currentURL != null && currentURL.equals(this.url)) {
                return;
            }
            this.editor.addPropertyChangeListener("page", this);
            try {
                this.editor.setPage(this.url);
                this.wait();
            }
            catch (Exception e) {
                JHelpPrintHandler.processException(e);
            }
            this.editor.removePropertyChangeListener("page", this);
        }

        public int getNumberOfPages() {
            if (this.transforms == null) {
                this.loadPage();
                this.transforms = this.createTransforms();
            }
            return this.transforms.size();
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            this.notifyAll();
        }

        /*
         * Exception decompiling
         */
        public Vector createTransforms() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 24[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void printHeader(Graphics2D g2d, int pi) {
            g2d.setClip(new Rectangle2D.Double(0.0, 0.0, this.pf.getWidth(), this.pf.getHeight()));
            g2d.setFont(new Font("Serif", 2, 10));
            String s = (String)this.editor.getDocument().getProperty("title") + " " + (pi + 1) + "/" + this.transforms.size();
            Rectangle2D rec = g2d.getFontMetrics().getStringBounds(s, g2d);
            g2d.drawString(s, (float)(this.pf.getWidth() - rec.getX() - rec.getWidth() - 36.0), 36.0f);
            g2d.setClip(new Rectangle2D.Double(this.pf.getImageableX(), this.pf.getImageableY(), this.pf.getImageableWidth(), this.pf.getImageableHeight()));
        }

        public int print(Graphics pg, PageFormat pageFormat, int pi) {
            JHelpPrintHandler.debug("Printing document page=" + pi);
            JHelpPrintHandler.debug("Printing page=" + (pi -= this.firstPage));
            if (pi >= this.getNumberOfPages()) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)pg;
            this.printHeader(g2d, pi);
            g2d.transform((AffineTransform)this.transforms.get(pi));
            JHelpPrintHandler.debug("Graphics tansform=" + g2d.getTransform());
            JHelpPrintHandler.debug("Graphics clip=" + g2d.getClip());
            Rectangle2D g2dRec = g2d.getClip().getBounds2D();
            double height = ((PageTransform)this.transforms.get(pi)).getHeight();
            double adjheight = g2dRec.getY() + g2dRec.getHeight() - 1.0 - height;
            if (adjheight > 0.0) {
                JHelpPrintHandler.debug("Graphics adjusted height=" + adjheight);
                g2d.clip(new Rectangle2D.Double(g2dRec.getX(), g2dRec.getY(), g2dRec.getWidth(), g2dRec.getHeight() - adjheight));
                g2dRec = g2d.getClip().getBounds2D();
                JHelpPrintHandler.debug("Graphics tansform=" + g2d.getTransform());
                JHelpPrintHandler.debug("Graphics clip=" + g2d.getClip());
            }
            if (!(g2dRec.getY() < height)) {
                return 1;
            }
            this.editor.paint(g2d);
            return 0;
        }
    }

    class PageTransform
    extends AffineTransform {
        private double height;

        PageTransform() {
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }
    }

    class PrintThread
    extends Thread {
        private URL[] urls;
        private int index = 0;

        PrintThread(URL url) {
            this(new URL[]{url});
        }

        PrintThread(URL[] urls) {
            this.urls = urls;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrinterJob job = JHelpPrintHandler.this.getPrinterJob();
            if (job != null) {
                PrinterJob printerJob = job;
                synchronized (printerJob) {
                    JHEditorPane editor = new JHEditorPane();
                    JHFrame frame = new JHFrame();
                    frame.setContentPane(editor);
                    try {
                        job.setPageable(new JHPageable(editor, this.urls, (PageFormat)JHelpPrintHandler.this.getPageFormat().clone()));
                    }
                    catch (Exception e) {
                        JHelpPrintHandler.processException(e);
                    }
                    if (job.printDialog()) {
                        try {
                            job.print();
                        }
                        catch (Exception e) {
                            JHelpPrintHandler.processException(e);
                        }
                    }
                    frame.dispose();
                }
            }
        }
    }

    class PageSetupThread
    extends Thread {
        PrinterJob job;

        PageSetupThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrinterJob job = JHelpPrintHandler.this.getPrinterJob();
            if (job != null) {
                PrinterJob printerJob = job;
                synchronized (printerJob) {
                    try {
                        JHelpPrintHandler.this.setPageFormat(job.pageDialog(JHelpPrintHandler.this.getPageFormat()));
                    }
                    catch (Exception e) {
                        JHelpPrintHandler.processException(e);
                    }
                }
            }
        }
    }
}

