/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class CustomKit
extends HTMLEditorKit {
    private MouseMotionListener mouseHandler = new MouseHandler();
    private static final boolean debug = false;

    public Object clone() {
        return new CustomKit();
    }

    public void install(JEditorPane c) {
        c.addMouseMotionListener(this.mouseHandler);
        super.install(c);
    }

    public void deinstall(JEditorPane c) {
        c.removeMouseMotionListener(this.mouseHandler);
        super.deinstall(c);
    }

    public Document createDefaultDocument() {
        HTMLDocument tmpDoc = (HTMLDocument)super.createDefaultDocument();
        CustomDocument doc = new CustomDocument(tmpDoc.getStyleSheet());
        doc.putProperty("__PARSER__", this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        CustomKit.debug("fetch custom document");
        return doc;
    }

    public ViewFactory getViewFactory() {
        CustomKit.debug("fetched custom factory");
        return new CustomFactory();
    }

    private static void debug(String str) {
    }

    static class ObjectView1
    extends ComponentView {
        public ObjectView1(Element elem) {
            super(elem);
        }

        protected Component createComponent() {
            AttributeSet attr = this.getElement().getAttributes();
            CustomKit.debug("attr: " + attr.copyAttributes());
            String classname = (String)attr.getAttribute(HTML.Attribute.CLASSID);
            try {
                Class c;
                Object o;
                String classtype;
                int colon = classname.indexOf(58);
                if (colon != -1 && (classtype = classname.substring(0, colon).toLowerCase()).compareTo("java") == 0 && (o = (c = this.getClass(classname = classname.substring(colon + 1))).newInstance()) instanceof Component) {
                    Component comp = (Component)o;
                    if (o instanceof ViewAwareComponent) {
                        ((ViewAwareComponent)((Object)comp)).setViewData(this);
                    }
                    this.setParameters(comp, attr);
                    return comp;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.getUnloadableRepresentation();
        }

        Component getUnloadableRepresentation() {
            JLabel comp = new JLabel("??");
            ((Component)comp).setForeground(Color.red);
            return comp;
        }

        private Class getClass(String classname) throws ClassNotFoundException {
            Class<?> klass = null;
            Class<?> docClass = this.getDocument().getClass();
            ClassLoader loader = docClass.getClassLoader();
            if (loader != null) {
                klass = loader.loadClass(classname);
            }
            if (klass == null) {
                klass = Class.forName(classname);
            }
            return klass;
        }

        private void setParameters(Component comp, AttributeSet attr) {
            BeanInfo bi;
            Class<?> k = comp.getClass();
            try {
                bi = Introspector.getBeanInfo(k);
            }
            catch (IntrospectionException ex) {
                CustomKit.debug("introspector failed, ex: " + ex);
                return;
            }
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                CustomKit.debug("checking on props[i]: " + props[i].getName());
                Object v = attr.getAttribute(props[i].getName());
                if (!(v instanceof String)) continue;
                String value = (String)v;
                Method writer = props[i].getWriteMethod();
                if (writer == null) {
                    return;
                }
                Class<?>[] params = writer.getParameterTypes();
                if (params.length != 1) {
                    return;
                }
                String[] args = new String[]{value};
                try {
                    writer.invoke((Object)comp, (Object[])args);
                    CustomKit.debug("Invocation succeeded");
                    continue;
                }
                catch (Exception ex) {
                    CustomKit.debug("Invocation failed");
                }
            }
        }
    }

    static class CustomDocument
    extends HTMLDocument {
        CustomDocument(StyleSheet s) {
            super(s);
        }

        public HTMLEditorKit.ParserCallback getReader(int pos) {
            Object desc = this.getProperty("stream");
            if (desc instanceof URL) {
                this.setBase((URL)desc);
            }
            CustomReader reader = new CustomReader(pos);
            return reader;
        }

        class CustomReader
        extends HTMLDocument.HTMLReader {
            public CustomReader(int offset) {
                super(CustomDocument.this, offset);
                this.registerTag(HTML.Tag.PARAM, new ObjectAction1());
            }

            Vector getParseBuffer() {
                return this.parseBuffer;
            }

            class ObjectAction1
            extends HTMLDocument.HTMLReader.SpecialAction {
                ObjectAction1() {
                    super(CustomReader.this);
                }

                public void start(HTML.Tag t, MutableAttributeSet a) {
                    if (t == HTML.Tag.PARAM) {
                        this.addParameter(a);
                    } else {
                        super.start(t, a);
                    }
                }

                public void end(HTML.Tag t) {
                    if (t != HTML.Tag.PARAM) {
                        super.end(t);
                    }
                }

                void addParameter(AttributeSet a) {
                    CustomKit.debug("addParameter AttributeSet=" + a);
                    String name = (String)a.getAttribute(HTML.Attribute.NAME);
                    String value = (String)a.getAttribute(HTML.Attribute.VALUE);
                    if (name != null && value != null) {
                        DefaultStyledDocument.ElementSpec objSpec = (DefaultStyledDocument.ElementSpec)CustomReader.this.getParseBuffer().lastElement();
                        MutableAttributeSet objAttr = (MutableAttributeSet)objSpec.getAttributes();
                        objAttr.addAttribute(name, value);
                    }
                }
            }
        }
    }

    static class CustomFactory
    extends HTMLEditorKit.HTMLFactory {
        CustomFactory() {
        }

        public View create(Element elem) {
            HTML.Tag kind;
            Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (o instanceof HTML.Tag && (kind = (HTML.Tag)o) == HTML.Tag.OBJECT) {
                CustomKit.debug("creating ObjectView1 for: " + elem);
                return new ObjectView1(elem);
            }
            return super.create(elem);
        }
    }

    public static class MouseHandler
    implements MouseMotionListener {
        private Element curElem = null;
        private Cursor origCursor;
        private Cursor handCursor = null;

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Document doc;
            Point pt;
            int pos;
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEditable() && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0 && (doc = editor.getDocument()) instanceof HTMLDocument) {
                String href;
                HTMLDocument hdoc = (HTMLDocument)doc;
                Element elem = hdoc.getCharacterElement(pos);
                AttributeSet a = elem.getAttributes();
                AttributeSet anchor = (AttributeSet)a.getAttribute(HTML.Tag.A);
                String string = href = anchor != null ? (String)anchor.getAttribute(HTML.Attribute.HREF) : null;
                if (href != null) {
                    if (this.curElem != elem) {
                        this.curElem = elem;
                        if (this.origCursor == null) {
                            this.origCursor = editor.getCursor();
                        }
                        if (this.handCursor == null) {
                            this.handCursor = Cursor.getPredefinedCursor(12);
                        }
                        editor.setCursor(this.handCursor);
                    }
                } else if (this.curElem != null) {
                    this.curElem = null;
                    editor.setCursor(this.origCursor);
                }
            }
        }
    }
}

