/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.core.action;

import com.artenum.rosetta.core.action.AbstractConsoleAction;
import com.artenum.rosetta.exception.ScriptException;
import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.interfaces.ui.PromptView;
import java.awt.event.ActionEvent;

public class ValidationAction
extends AbstractConsoleAction {
    private static final long serialVersionUID = 1L;

    @Override
    public void actionPerformed(ActionEvent e) {
        InputParsingManager inputParsingManager = this.configuration.getInputParsingManager();
        OutputView outputView = this.configuration.getOutputView();
        PromptView promptView = this.configuration.getPromptView();
        String cmdToExecute = null;
        outputView.setCaretPositionToEnd();
        if (inputParsingManager.isBlockEditing()) {
            inputParsingManager.append("\n");
            promptView.updatePrompt();
        } else {
            cmdToExecute = inputParsingManager.getCommandLine();
            inputParsingManager.reset();
            promptView.updatePrompt();
            this.configuration.getHistoryManager().setTmpEntry(null);
            this.configuration.getHistoryManager().setInHistory(false);
            boolean firstPrompt = true;
            for (String line : cmdToExecute.split("\n")) {
                outputView.append("\n");
                if (firstPrompt) {
                    firstPrompt = false;
                    outputView.append(promptView.getDefaultPrompt());
                } else {
                    outputView.append(promptView.getInBlockPrompt());
                }
                outputView.append(line);
            }
            outputView.append("\n");
            try {
                this.configuration.getGenericInterpreter().eval(cmdToExecute);
            }
            catch (ScriptException e1) {
                e1.printStackTrace();
            }
            if (cmdToExecute.length() == 0) {
                this.configuration.getInputCommandView().setText(" ");
                this.configuration.getInputCommandView().backspace();
            }
        }
    }
}

