/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class SkinFileChooserUI
extends MetalFileChooserUI {
    static final int space = 10;

    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
    }

    protected MetalFileChooserUI.FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new MyFilterComboBoxRenderer(this);
    }

    protected MyDirectoryComboBoxRenderer createMyDirectoryComboBoxRenderer(JFileChooser fc) {
        return new MyDirectoryComboBoxRenderer(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SkinFileChooserUI((JFileChooser)c);
    }

    public SkinFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    public class MyFilterComboBoxRenderer
    extends MetalFileChooserUI.FilterComboBoxRenderer {
        private final /* synthetic */ SkinFileChooserUI this$0;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FileFilter filter = (FileFilter)value;
            if (filter != null) {
                this.setText(filter.getDescription());
            }
            return this;
        }

        public MyFilterComboBoxRenderer(SkinFileChooserUI skinFileChooserUI) {
            SkinFileChooserUI skinFileChooserUI2 = skinFileChooserUI;
            if (skinFileChooserUI2 == null) {
                throw null;
            }
            super(skinFileChooserUI2);
            this.this$0 = skinFileChooserUI;
            this.setOpaque(false);
            this.setBorder(null);
        }
    }

    class MyDirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;
        private final /* synthetic */ SkinFileChooserUI this$0;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            if (index == -1) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File directory = (File)value;
            if (directory == null) {
                this.setText("");
                return this;
            }
            String fileName = this.this$0.getFileChooser().getName(directory);
            this.setText(fileName);
            int depth = 0;
            if (index != -1) {
                File f = directory;
                while (f.getParent() != null) {
                    ++depth;
                    f = this.this$0.getFileChooser().getFileSystemView().createFileObject(f.getParent());
                }
            }
            this.ii.icon = icon = this.this$0.getFileChooser().getIcon(directory);
            this.ii.depth = depth;
            this.setIcon(this.ii);
            return this;
        }

        MyDirectoryComboBoxRenderer(SkinFileChooserUI skinFileChooserUI) {
            SkinFileChooserUI skinFileChooserUI2 = this.this$0 = skinFileChooserUI;
            if (skinFileChooserUI2 == null) {
                throw null;
            }
            this.ii = skinFileChooserUI2.new IndentIcon();
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x + this.depth * 10, y);
        }

        IndentIcon() {
        }
    }
}

